/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;

abstract class AbstractAutoIndexerImpl<T extends PropertyContainer>
implements TransactionEventHandler<Void>,
AutoIndexer<T> {
    private final Set<String> propertyKeysToInclude = new HashSet<String>();
    private final EmbeddedGraphDbImpl gdb;
    private volatile boolean enabled;

    public AbstractAutoIndexerImpl(EmbeddedGraphDbImpl gdb) {
        this.gdb = gdb;
        this.resolveConfig();
    }

    @Override
    public ReadableIndex<T> getAutoIndex() {
        return new IndexWrapper<T>(this.getIndexInternal());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable && !this.enabled) {
            this.gdb.registerTransactionEventHandler(this);
        } else if (!enable && this.enabled) {
            this.gdb.unregisterTransactionEventHandler(this);
        }
        this.enabled = enable;
    }

    @Override
    public void startAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.add(propName);
    }

    @Override
    public void stopAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.remove(propName);
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return Collections.unmodifiableSet(this.propertyKeysToInclude);
    }

    protected EmbeddedGraphDbImpl getGraphDbImpl() {
        return this.gdb;
    }

    protected abstract Iterable<PropertyEntry<T>> getRemovedPropertiesOnCommit(TransactionData var1);

    protected abstract Iterable<PropertyEntry<T>> getAssignedPropertiesOnCommit(TransactionData var1);

    protected abstract Index<T> getIndexInternal();

    protected abstract String getAutoIndexConfigListName();

    protected abstract String getEnableConfigName();

    protected abstract String getAutoIndexName();

    private void handleProperties(Iterable<PropertyEntry<T>> removed, Iterable<PropertyEntry<T>> assigned) {
        Index<T> nodeIndex = this.getIndexInternal();
        for (PropertyEntry<T> entry : assigned) {
            Object previousValue = entry.previouslyCommitedValue();
            String key = entry.key();
            if (this.propertyKeysToInclude.contains(key)) {
                if (previousValue != null) {
                    nodeIndex.remove(entry.entity(), key, previousValue);
                }
                nodeIndex.add(entry.entity(), key, entry.value());
                continue;
            }
            if (previousValue == null) continue;
            nodeIndex.remove(entry.entity(), key, previousValue);
        }
        for (PropertyEntry<T> entry : removed) {
            String key = entry.key();
            Object previouslyCommitedValue = entry.previouslyCommitedValue();
            if (previouslyCommitedValue == null) continue;
            nodeIndex.remove(entry.entity(), key, previouslyCommitedValue);
        }
    }

    private void resolveConfig() {
        Config config = this.gdb.getConfig();
        boolean enable = Boolean.parseBoolean((String)config.getParams().get(this.getEnableConfigName()));
        this.setEnabled(enable);
        this.propertyKeysToInclude.addAll(this.parseConfigList((String)config.getParams().get(this.getAutoIndexConfigListName())));
    }

    private Set<String> parseConfigList(String list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<String> toReturn = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            if ((currentToken = currentToken.trim()).length() <= 0) continue;
            toReturn.add(currentToken);
        }
        return toReturn;
    }

    @Override
    public Void beforeCommit(TransactionData data) throws Exception {
        this.handleProperties(this.getRemovedPropertiesOnCommit(data), this.getAssignedPropertiesOnCommit(data));
        return null;
    }

    @Override
    public void afterCommit(TransactionData data, Void state) {
    }

    @Override
    public void afterRollback(TransactionData data, Void state) {
    }

    static class ReadOnlyIndexToIndexAdapter<T extends PropertyContainer>
    implements Index<T> {
        private final ReadableIndex<T> delegate;

        public ReadOnlyIndexToIndexAdapter(ReadableIndex<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Class<T> getEntityType() {
            return this.delegate.getEntityType();
        }

        @Override
        public IndexHits<T> get(String key, Object value) {
            return this.delegate.get(key, value);
        }

        @Override
        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            return this.delegate.query(key, queryOrQueryObject);
        }

        @Override
        public IndexHits<T> query(Object queryOrQueryObject) {
            return this.delegate.query(queryOrQueryObject);
        }

        @Override
        public void add(T entity, String key, Object value) {
            throw new UnsupportedOperationException("read only index");
        }

        @Override
        public void remove(T entity, String key, Object value) {
            throw new UnsupportedOperationException("read only index");
        }

        @Override
        public void remove(T entity, String key) {
            throw new UnsupportedOperationException("read only index");
        }

        @Override
        public void remove(T entity) {
            throw new UnsupportedOperationException("read only index");
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("read only index");
        }
    }

    private static class IndexWrapper<K extends PropertyContainer>
    implements ReadableIndex<K> {
        private final Index<K> delegate;

        IndexWrapper(Index<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Class<K> getEntityType() {
            return this.delegate.getEntityType();
        }

        @Override
        public IndexHits<K> get(String key, Object value) {
            return this.delegate.get(key, value);
        }

        @Override
        public IndexHits<K> query(String key, Object queryOrQueryObject) {
            return this.delegate.query(key, queryOrQueryObject);
        }

        @Override
        public IndexHits<K> query(Object queryOrQueryObject) {
            return this.delegate.query(queryOrQueryObject);
        }
    }
}

