/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class AnnotationProcessor
extends AbstractProcessor {
    private static Pattern nl = Pattern.compile("\n");

    AnnotationProcessor() {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(typeElement)) continue;
                    try {
                        this.process(typeElement, element, annotationMirror, this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString(), element, annotationMirror);
                    }
                }
            }
        }
        return false;
    }

    protected final void warn(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
    }

    protected final void warn(Element element, AnnotationMirror annotation, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element, annotation);
    }

    abstract void process(TypeElement var1, Element var2, AnnotationMirror var3, Map<? extends ExecutableElement, ? extends AnnotationValue> var4) throws IOException;

    void addTo(String line, String ... path) throws IOException {
        File file;
        FileObject fo = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path(path));
        URI uri = fo.toUri();
        try {
            file = new File(uri);
        }
        catch (Exception e) {
            file = new File(uri.toString());
        }
        if (file.exists()) {
            for (String previous : nl.split(fo.getCharContent(true), 0)) {
                if (!line.equals(previous)) continue;
                return;
            }
        }
        new FileWriter(file, true).append(line).append("\n").close();
    }

    Writer append(String ... path) throws IOException {
        FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path(path));
        URI uri = file.toUri();
        return new FileWriter(new File(uri.toString()), true);
    }

    private String path(String[] path) {
        StringBuilder filename = new StringBuilder();
        String sep = "";
        for (String part : path) {
            filename.append(sep).append(part);
            sep = "/";
        }
        return filename.toString();
    }
}

