/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class StandaloneWithShell {
    private static Logger log = Logger.getLogger(StandaloneWithShell.class.getName());
    private GraphDatabaseService embeddedDb;
    private AtomicBoolean shutdownInitiated = new AtomicBoolean(false);

    private GraphDatabaseService getGraphDb() {
        return this.embeddedDb;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StandaloneWithShell.this.shutdown();
            }
        });
    }

    private void initialize(Map<String, String> arguments) {
        String path = arguments.get("path");
        this.embeddedDb = new EmbeddedGraphDatabase(path, MapUtil.stringMap("enable_remote_shell", "true"));
        log.info("Neo4j started at '" + path + "'");
    }

    private void blockUntilShutdown() {
        try {
            while (!this.shutdownInitiated.get()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void shutdown() {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            log.info("Shutting down...");
            try {
                if (this.getGraphDb() != null) {
                    this.getGraphDb().shutdown();
                    this.embeddedDb = null;
                }
            }
            catch (Throwable t) {
                log.warning("Error shutting down Neo: " + t);
            }
        }
    }

    public void execute(Map<String, String> arguments) {
        this.addShutdownHook();
        this.initialize(arguments);
        this.blockUntilShutdown();
    }

    public static void main(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            String key = arg.substring(1);
            String value = ++i < args.length ? args[i] : null;
            arguments.put(key, value);
        }
        if (!arguments.containsKey("path")) {
            System.out.println("Use -path <path> to control the neo4j store path");
            return;
        }
        new StandaloneWithShell().execute(arguments);
    }
}

