/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.util.ArrayMap;

class ReadTransaction {
    private final NeoStore neoStore;

    public ReadTransaction(NeoStore neoStore) {
        this.neoStore = neoStore;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public boolean nodeLoadLight(long nodeId) {
        return this.getNodeStore().loadLightNode(nodeId);
    }

    public RelationshipData relationshipLoad(long id) {
        RelationshipRecord relRecord = this.getRelationshipStore().getLightRel(id);
        if (relRecord != null) {
            return new RelationshipData(id, relRecord.getFirstNode(), relRecord.getSecondNode(), relRecord.getType());
        }
        return null;
    }

    public RelationshipChainPosition getRelationshipChainPosition(long nodeId) {
        NodeRecord nodeRecord = this.getNodeStore().getRecord(nodeId);
        long nextRel = nodeRecord.getNextRel();
        return new RelationshipChainPosition(nextRel);
    }

    public Iterable<RelationshipData> getMoreRelationships(long nodeId, RelationshipChainPosition position) {
        long nextRel = position.getNextRecord();
        ArrayList<RelationshipData> rels = new ArrayList<RelationshipData>();
        for (int i = 0; i < this.getRelGrabSize() && nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            RelationshipRecord relRecord = this.getRelationshipStore().getChainRecord(nextRel);
            if (relRecord == null) {
                position.setNextRecord(Record.NO_NEXT_RELATIONSHIP.intValue());
                return rels;
            }
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                rels.add(new RelationshipData(relRecord.getId(), firstNode, secondNode, relRecord.getType()));
            } else {
                --i;
            }
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            System.out.println(relRecord);
            throw new InvalidRecordException("Node[" + nodeId + "] is neither firstNode[" + firstNode + "] nor secondNode[" + secondNode + "] for Relationship[" + relRecord.getId() + "]");
        }
        position.setNextRecord(nextRel);
        return rels;
    }

    public ArrayMap<Integer, PropertyData> relGetProperties(long relId) {
        RelationshipRecord relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        long nextProp = relRecord.getNextProp();
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    ArrayMap<Integer, PropertyData> nodeGetProperties(long nodeId) {
        NodeRecord nodeRecord = this.getNodeStore().getRecord(nodeId);
        long nextProp = nodeRecord.getNextProp();
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    public Object propertyGetValueOrNull(PropertyRecord propertyRecord) {
        return propertyRecord.getType().getValue(propertyRecord, null);
    }

    public Object propertyGetValue(long id) {
        PropertyRecord propertyRecord = this.getPropertyStore().getRecord(id);
        if (propertyRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propertyRecord);
        }
        return propertyRecord.getType().getValue(propertyRecord, this.getPropertyStore());
    }

    String getPropertyIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = indexStore.getRecord(id);
        if (index.isLight()) {
            indexStore.makeHeavy(index);
        }
        return indexStore.getStringFor(index);
    }

    PropertyIndexData[] getPropertyIndexes(int count) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getPropertyIndexes(count);
    }

    public int getKeyIdForProperty(long propertyId) {
        PropertyRecord propRecord = this.getPropertyStore().getLightRecord(propertyId);
        return propRecord.getKeyIndexId();
    }
}

