/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.impl.transaction.xaframework.BufferedReadableByteChannel;
import org.neo4j.kernel.impl.transaction.xaframework.CloseableByteBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.MemoryMappedLogBuffer;

public abstract class DefaultLogBufferFactory
implements LogBufferFactory {
    public static LogBufferFactory create(Map<?, ?> config) {
        String configValue = config != null ? (String)config.get("use_memory_mapped_buffers") : null;
        boolean memoryMapped = Boolean.parseBoolean(configValue);
        if (!memoryMapped || Config.osIsWindows()) {
            return new LogBufferFactory(){

                @Override
                public LogBuffer create(FileChannel fileChannel) throws IOException {
                    return new DirectMappedLogBuffer(fileChannel);
                }

                @Override
                public FileChannel combine(FileChannel fileChannel, LogBuffer logBuffer) throws IOException {
                    CloseableByteBuffer byteBuffer = ((DirectMappedLogBuffer)logBuffer).getBuffer();
                    byteBuffer.flip();
                    return new BufferedReadableByteChannel(fileChannel, byteBuffer);
                }
            };
        }
        return new DefaultLogBufferFactory(){};
    }

    @Override
    public LogBuffer create(FileChannel fileChannel) throws IOException {
        return new MemoryMappedLogBuffer(fileChannel);
    }

    @Override
    public FileChannel combine(FileChannel fileChannel, LogBuffer logBuffer) throws IOException {
        return fileChannel;
    }
}

