/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.EmbeddedGraphDbImpl;

class RelationshipAutoIndexerImpl
extends AbstractAutoIndexerImpl<Relationship> {
    static final String RELATIONSHIP_AUTO_INDEX = "relationship_auto_index";

    public RelationshipAutoIndexerImpl(EmbeddedGraphDbImpl gdb) {
        super(gdb);
    }

    @Override
    protected Iterable<PropertyEntry<Relationship>> getAssignedPropertiesOnCommit(TransactionData data) {
        return data.assignedRelationshipProperties();
    }

    @Override
    protected String getAutoIndexConfigListName() {
        return "relationship_keys_indexable";
    }

    @Override
    protected String getAutoIndexName() {
        return RELATIONSHIP_AUTO_INDEX;
    }

    @Override
    protected String getEnableConfigName() {
        return "relationship_auto_indexing";
    }

    @Override
    protected Index<Relationship> getIndexInternal() {
        return this.getGraphDbImpl().index().forRelationships(RELATIONSHIP_AUTO_INDEX);
    }

    @Override
    protected Iterable<PropertyEntry<Relationship>> getRemovedPropertiesOnCommit(TransactionData data) {
        return data.removedRelationshipProperties();
    }
}

