/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;

public class TopLevelTransaction
implements Transaction {
    private boolean success = false;
    private final TransactionManager transactionManager;

    public TopLevelTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void failure() {
        this.success = false;
        try {
            this.transactionManager.getTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
        }
    }

    @Override
    public void success() {
        this.success = true;
    }

    protected boolean isMarkedAsSuccessful() {
        try {
            return this.success && this.transactionManager.getTransaction().getStatus() != 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public void finish() {
        try {
            if (this.success) {
                if (this.transactionManager.getTransaction() != null) {
                    this.transactionManager.getTransaction().commit();
                }
            } else if (this.transactionManager.getTransaction() != null) {
                this.transactionManager.getTransaction().rollback();
            }
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Unable to commit transaction", e);
        }
        catch (Exception e) {
            if (this.success) {
                throw new TransactionFailureException("Unable to commit transaction", e);
            }
            throw new TransactionFailureException("Unable to rollback transaction", e);
        }
    }
}

