/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;

abstract class WrappedEntity<G extends WrappedGraphDatabase, T extends PropertyContainer>
implements PropertyContainer {
    protected final G graphdb;

    WrappedEntity(G graphdb) {
        this.graphdb = graphdb;
    }

    protected abstract T actual();

    public int hashCode() {
        return this.actual().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            WrappedEntity other = (WrappedEntity)obj;
            return this.actual().equals(other.actual()) && ((WrappedGraphDatabase)this.graphdb).equals(other.graphdb);
        }
        return false;
    }

    public String toString() {
        return this.actual().toString();
    }

    static <T extends PropertyContainer> T unwrap(T entity) {
        if (entity instanceof WrappedEntity) {
            return ((WrappedEntity)entity).actual();
        }
        return entity;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.graphdb;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.actual().hasProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.actual().getProperty(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.actual().getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.actual().setProperty(key, value);
    }

    @Override
    public Object removeProperty(String key) {
        return this.actual().removeProperty(key);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.actual().getPropertyKeys();
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.actual().getPropertyValues();
    }
}

