/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.kernel.impl.transaction.xaframework.CloseableByteBuffer;

class BufferedReadableByteChannel
extends FileChannel {
    private final FileChannel fileChannel;
    private CloseableByteBuffer byteBuffer;
    private final long bufferStartPosition;
    private long position;

    BufferedReadableByteChannel(FileChannel fileChannel, CloseableByteBuffer buffer) throws IOException {
        this.fileChannel = fileChannel;
        this.bufferStartPosition = fileChannel.size();
        this.position = fileChannel.position();
        this.byteBuffer = buffer;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.position == this.size()) {
            return -1;
        }
        int result = 0;
        if (this.position < this.bufferStartPosition) {
            result += this.fileChannel.read(dst);
        }
        while (dst.hasRemaining() && this.byteBuffer.hasRemaining()) {
            dst.put(this.byteBuffer.get());
            ++result;
        }
        this.position += (long)result;
        return result;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < this.bufferStartPosition) {
            this.byteBuffer.position(0);
            this.fileChannel.position(newPosition);
        } else {
            this.fileChannel.position(this.fileChannel.size());
            this.byteBuffer.position((int)(newPosition - this.bufferStartPosition));
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.fileChannel.size() + (long)this.byteBuffer.limit();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        long startingPosition = this.position;
        this.position(position);
        int result = this.read(dst);
        this.position(startingPosition);
        return result;
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.fileChannel.close();
        this.byteBuffer.close();
    }
}

