/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class RelationshipImpl
extends Primitive {
    RelationshipImpl(long startNodeId, long endNodeId, boolean newRel) {
        super(newRel);
    }

    protected RelationshipType assertTypeNotNull(RelationshipType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return type;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelationshipImpl && ((RelationshipImpl)obj).getId() == this.getId();
    }

    @Override
    protected PropertyData changeProperty(NodeManager nodeManager, PropertyData property, Object value) {
        return nodeManager.relChangeProperty(this, property, value);
    }

    @Override
    protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.relAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, PropertyData property) {
        nodeManager.relRemoveProperty(this, property);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    public Node[] getNodes(NodeManager nodeManager) {
        return new Node[]{new NodeProxy(this.getStartNodeId(), nodeManager), new NodeProxy(this.getEndNodeId(), nodeManager)};
    }

    public Node getOtherNode(NodeManager nodeManager, Node node) {
        if (this.getStartNodeId() == node.getId()) {
            return new NodeProxy(this.getEndNodeId(), nodeManager);
        }
        if (this.getEndNodeId() == node.getId()) {
            return new NodeProxy(this.getStartNodeId(), nodeManager);
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    public Node getStartNode(NodeManager nodeManager) {
        return new NodeProxy(this.getStartNodeId(), nodeManager);
    }

    abstract long getStartNodeId();

    public Node getEndNode(NodeManager nodeManager) {
        return new NodeProxy(this.getEndNodeId(), nodeManager);
    }

    abstract long getEndNodeId();

    public abstract RelationshipType getType(NodeManager var1);

    public boolean isType(NodeManager nodeManager, RelationshipType otherType) {
        return otherType != null && otherType.name().equals(this.getType(nodeManager).name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager) {
        NodeImpl startNode = null;
        NodeImpl endNode = null;
        boolean startNodeLocked = false;
        boolean endNodeLocked = false;
        boolean thisLocked = false;
        boolean success = false;
        try {
            startNode = nodeManager.getLightNode(this.getStartNodeId());
            if (startNode != null) {
                nodeManager.acquireLock(startNode, LockType.WRITE);
                startNodeLocked = true;
            }
            if ((endNode = nodeManager.getLightNode(this.getEndNodeId())) != null) {
                nodeManager.acquireLock(endNode, LockType.WRITE);
                endNodeLocked = true;
            }
            nodeManager.acquireLock(this, LockType.WRITE);
            thisLocked = true;
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this, true);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteRelationship(this);
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
            RelationshipType type = this.getType(nodeManager);
            long id = this.getId();
            if (startNode != null) {
                startNode.removeRelationship(nodeManager, type, id);
            }
            if (endNode != null) {
                endNode.removeRelationship(nodeManager, type, id);
            }
            success = true;
        }
        finally {
            boolean releaseFailed = false;
            try {
                if (thisLocked) {
                    nodeManager.releaseLock(this, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed = true;
                e.printStackTrace();
            }
            try {
                if (startNodeLocked) {
                    nodeManager.releaseLock(startNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed = true;
                e.printStackTrace();
            }
            try {
                if (endNodeLocked) {
                    nodeManager.releaseLock(endNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed = true;
                e.printStackTrace();
            }
            if (!success) {
                nodeManager.setRollbackOnly();
            }
            if (releaseFailed) {
                throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship delete->" + this);
            }
        }
    }

    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.getType(null) + " between Node[" + this.getStartNodeId() + "] and Node[" + this.getEndNodeId() + "]";
    }
}

