/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StringLogger {
    public static final String DEFAULT_NAME = "messages.log";
    public static final StringLogger SYSTEM = new StringLogger(new PrintWriter(System.out));
    private static final int DEFAULT_THRESHOLD_FOR_ROTATION_MB = 100;
    private static final int NUMBER_OF_OLD_LOGS_TO_KEEP = 2;
    private PrintWriter out;
    private final Integer rotationThreshold;
    private final File file;
    private static final Map<String, StringLogger> loggers = new HashMap<String, StringLogger>();

    private StringLogger(String filename, int rotationThresholdMb) {
        this.rotationThreshold = rotationThresholdMb * 1024 * 1024;
        try {
            this.file = new File(filename);
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.instantiateWriter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void instantiateWriter() throws IOException {
        this.out = new PrintWriter(new FileWriter(this.file, true));
    }

    private StringLogger(PrintWriter writer) {
        this.out = writer;
        this.rotationThreshold = null;
        this.file = null;
    }

    public static StringLogger getLogger(String storeDir) {
        return StringLogger.getLogger(storeDir, 100);
    }

    public static StringLogger getLogger(String storeDir, int rotationThresholdMb) {
        if (storeDir == null) {
            return SYSTEM;
        }
        String filename = StringLogger.defaultFileName(storeDir);
        StringLogger logger = loggers.get(filename);
        if (logger == null) {
            logger = new StringLogger(filename, rotationThresholdMb);
            loggers.put(filename, logger);
        }
        return logger;
    }

    private static String defaultFileName(String storeDir) {
        return new File(storeDir, DEFAULT_NAME).getAbsolutePath();
    }

    public void logMessage(String msg) {
        this.logMessage(msg, false);
    }

    public void logMessage(String msg, Throwable cause) {
        this.logMessage(msg, cause, false);
    }

    public synchronized void logMessage(String msg, boolean flush) {
        this.ensureOpen();
        this.out.println(new Date() + ": " + msg);
        if (flush) {
            this.out.flush();
        }
        this.checkRotation();
    }

    public synchronized void logMessage(String msg, Throwable cause, boolean flush) {
        this.ensureOpen();
        this.out.println(new Date() + ": " + msg + " " + cause.getMessage());
        cause.printStackTrace(this.out);
        if (flush) {
            this.out.flush();
        }
        this.checkRotation();
    }

    private void ensureOpen() {
        if (this.out.checkError()) {
            this.out.close();
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkRotation() {
        if (this.rotationThreshold != null && this.file.length() > (long)this.rotationThreshold.intValue()) {
            this.doRotation();
        }
    }

    private void doRotation() {
        this.out.close();
        this.moveAwayFile();
        try {
            this.instantiateWriter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void moveAwayFile() {
        File oldLogFile = new File(this.file.getParentFile(), this.file.getName() + "." + 2);
        if (oldLogFile.exists()) {
            oldLogFile.delete();
        }
        for (int i = 1; i >= 0; --i) {
            oldLogFile = new File(this.file.getParentFile(), this.file.getName() + (i == 0 ? "" : "." + i));
            if (!oldLogFile.exists()) continue;
            oldLogFile.renameTo(new File(this.file.getParentFile(), this.file.getName() + "." + (i + 1)));
        }
    }

    public void flush() {
        this.out.flush();
    }

    public static synchronized void close(String storeDir) {
        StringLogger logger = loggers.remove(StringLogger.defaultFileName(storeDir));
        if (logger != null) {
            logger.out.close();
        }
    }
}

