/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.reflect.Array;

public class SizeOfs {
    public static int sizeOf(String value) {
        return SizeOfs.withObjectOverhead(20 + SizeOfs.withArrayOverhead(value.length() * 2));
    }

    public static int sizeOfArray(Object value) {
        int base;
        if (value instanceof String[]) {
            int size = 0;
            for (String string : (String[])value) {
                size += SizeOfs.withReference(SizeOfs.sizeOf(string));
            }
            return SizeOfs.withArrayOverhead(size);
        }
        if (value instanceof byte[] || value instanceof boolean[]) {
            base = 1;
        } else if (value instanceof short[] || value instanceof char[]) {
            base = 2;
        } else if (value instanceof int[] || value instanceof float[]) {
            base = 4;
        } else if (value instanceof long[] || value instanceof double[]) {
            base = 8;
        } else if (value instanceof Byte[] || value instanceof Boolean[] || value instanceof Short[] || value instanceof Character[] || value instanceof Integer[] || value instanceof Float[] || value instanceof Long[] || value instanceof Double[]) {
            base = 32;
        } else {
            throw new IllegalStateException("Unkown type: " + value.getClass() + " [" + value + "]");
        }
        return SizeOfs.withArrayOverhead(base * Array.getLength(value));
    }

    public static int withObjectOverhead(int size) {
        return 16 + size;
    }

    public static int withArrayOverhead(int size) {
        return 24 + size;
    }

    public static int withArrayOverhead(int size, int length) {
        return SizeOfs.withArrayOverhead(size + length * 8);
    }

    public static int withReference(int size) {
        return 8 + size;
    }
}

