/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;

public class GraphDbModule {
    private static final String DEFAULT_CACHE_TYPE = "soft";
    private static Logger log = Logger.getLogger(GraphDbModule.class.getName());
    private boolean startIsOk = true;
    private static final int INDEX_COUNT = 2500;
    private final GraphDatabaseService graphDbService;
    private final TransactionManager transactionManager;
    private final LockManager lockManager;
    private final EntityIdGenerator idGenerator;
    private NodeManager nodeManager;
    private MeasureDoNothing monitorGc;
    private boolean readOnly = false;

    public GraphDbModule(GraphDatabaseService graphDb, LockManager lockManager, TransactionManager transactionManager, EntityIdGenerator idGenerator, boolean readOnly) {
        this.graphDbService = graphDb;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.idGenerator = idGenerator;
        this.readOnly = readOnly;
    }

    public void init() {
    }

    public void start(LockReleaser lockReleaser, PersistenceManager persistenceManager, RelationshipTypeCreator relTypeCreator, DiagnosticsManager diagnostics, Map<Object, Object> params, Caches caches) {
        if (!this.startIsOk) {
            return;
        }
        CacheProvider cacheProvider = null;
        HashMap<String, CacheProvider> cacheProviders = new HashMap<String, CacheProvider>();
        for (CacheProvider provider : Service.load(CacheProvider.class)) {
            cacheProviders.put(provider.getName(), provider);
        }
        String cacheTypeName = (String)params.get("cache_type");
        if (cacheTypeName == null) {
            cacheTypeName = DEFAULT_CACHE_TYPE;
        }
        if ((cacheProvider = (CacheProvider)cacheProviders.get(cacheTypeName)) == null) {
            throw new IllegalArgumentException("No cache type '" + cacheTypeName + "'");
        }
        caches.configure(cacheProvider, params);
        Cache<NodeImpl> nodeCache = diagnostics.tryAppendProvider(caches.node());
        Cache<RelationshipImpl> relCache = diagnostics.tryAppendProvider(caches.relationship());
        this.nodeManager = !this.readOnly ? new NodeManager(this.graphDbService, this.lockManager, lockReleaser, this.transactionManager, persistenceManager, this.idGenerator, relTypeCreator, cacheProvider, diagnostics, params, nodeCache, relCache) : new ReadOnlyNodeManager(this.graphDbService, this.lockManager, lockReleaser, this.transactionManager, persistenceManager, this.idGenerator, cacheProvider, diagnostics, params, nodeCache, relCache);
        NameData[] relTypes = null;
        NameData[] propertyIndexes = null;
        relTypes = persistenceManager.loadAllRelationshipTypes();
        propertyIndexes = persistenceManager.loadPropertyIndexes(2500);
        this.nodeManager.addRawRelationshipTypes(relTypes);
        this.nodeManager.addPropertyIndexes(propertyIndexes);
        if (propertyIndexes.length < 2500) {
            this.nodeManager.setHasAllpropertyIndexes(true);
        }
        this.nodeManager.start(params);
        this.startGCMonitor(params);
        this.startIsOk = false;
    }

    private void startGCMonitor(Map<Object, Object> params) {
        int monitor_wait_time = 100;
        try {
            String value = (String)params.get("gc_monitor_wait_time");
            if (value != null) {
                monitor_wait_time = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int monitor_threshold = 200;
        try {
            String value = (String)params.get("gc_monitor_threshold");
            if (value != null) {
                monitor_threshold = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringLogger logger = (StringLogger)params.get(StringLogger.class);
        this.monitorGc = new MeasureDoNothing(logger, monitor_wait_time, monitor_threshold);
        this.monitorGc.start();
    }

    private void beginTx() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionFailureException("Unable to begin transaction.", e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to begin transaction.", e);
        }
    }

    private void commitTx() {
        try {
            this.transactionManager.commit();
        }
        catch (SecurityException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
    }

    public void setReferenceNodeId(Long nodeId) {
        this.nodeManager.setReferenceNodeId(nodeId);
        try {
            this.nodeManager.getReferenceNode();
        }
        catch (NotFoundException e) {
            log.warning("Reference node[" + nodeId + "] not valid.");
        }
    }

    public Long getCurrentReferenceNodeId() {
        try {
            return this.nodeManager.getReferenceNode().getId();
        }
        catch (NotFoundException e) {
            return -1L;
        }
    }

    public Node createNewReferenceNode() {
        Node node = this.nodeManager.createNode();
        this.nodeManager.setReferenceNodeId(node.getId());
        return node;
    }

    public void reload(Map<Object, Object> params) {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        this.nodeManager.clearPropertyIndexes();
        this.nodeManager.clearCache();
        this.nodeManager.stop();
        this.monitorGc.stopMeasuring();
    }

    public void destroy() {
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }

    protected Caches createCaches(StringLogger logger) {
        return new DefaultCaches(logger);
    }
}

