/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public class TxLog {
    private String name = null;
    private LogBuffer logBuffer;
    private int recordCount = 0;
    public static final byte TX_START = 1;
    public static final byte BRANCH_ADD = 2;
    public static final byte MARK_COMMIT = 3;
    public static final byte TX_DONE = 4;
    private final FileSystemAbstraction fileSystem;

    public TxLog(String fileName, FileSystemAbstraction fileSystem) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        this.fileSystem = fileSystem;
        FileChannel fileChannel = fileSystem.open(fileName, "rw");
        fileChannel.position(fileChannel.size());
        this.logBuffer = new DirectMappedLogBuffer(fileChannel);
        this.name = fileName;
    }

    public String getName() {
        return this.name;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void close() throws IOException {
        this.logBuffer.force();
        this.logBuffer.getFileChannel().close();
    }

    public void force() throws IOException {
        this.logBuffer.force();
    }

    public synchronized void truncate() throws IOException {
        FileChannel fileChannel = this.logBuffer.getFileChannel();
        fileChannel.position(0L);
        fileChannel.truncate(0L);
        this.recordCount = 0;
        this.logBuffer = new DirectMappedLogBuffer(fileChannel);
    }

    public synchronized void txStart(byte[] globalId) throws IOException {
        this.assertNotNull(globalId, "global id");
        this.logBuffer.put((byte)1).put((byte)globalId.length).put(globalId);
        ++this.recordCount;
    }

    private void assertNotNull(Object globalId, String name) {
        if (globalId == null) {
            throw new IllegalArgumentException("Null " + name);
        }
    }

    public synchronized void addBranch(byte[] globalId, byte[] branchId) throws IOException {
        this.assertNotNull(globalId, "global id");
        this.assertNotNull(branchId, "branch id");
        this.logBuffer.put((byte)2).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId);
        ++this.recordCount;
    }

    public synchronized void markAsCommitting(byte[] globalId, ForceMode forceMode) throws IOException {
        this.assertNotNull(globalId, "global id");
        this.logBuffer.put((byte)3).put((byte)globalId.length).put(globalId);
        forceMode.force(this.logBuffer);
        ++this.recordCount;
    }

    public synchronized void txDone(byte[] globalId) throws IOException {
        this.assertNotNull(globalId, "global id");
        this.logBuffer.put((byte)4).put((byte)globalId.length).put(globalId);
        ++this.recordCount;
    }

    void writeRecord(Record record, ForceMode forceMode) throws IOException {
        if (record.getType() == 1) {
            this.txStart(record.getGlobalId());
        } else if (record.getType() == 2) {
            this.addBranch(record.getGlobalId(), record.getBranchId());
        } else if (record.getType() == 3) {
            this.markAsCommitting(record.getGlobalId(), forceMode);
        } else {
            throw new IOException("Illegal record type[" + record.getType() + "]");
        }
    }

    public synchronized Iterator<List<Record>> getDanglingRecords() throws IOException {
        FileChannel fileChannel = this.logBuffer.getFileChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(131000);
        fileChannel.position(0L);
        buffer.clear();
        fileChannel.read(buffer);
        buffer.flip();
        long nextPosition = 0L;
        int seqNr = 0;
        HashMap recordMap = new HashMap();
        while (buffer.hasRemaining()) {
            List<Record> recordList;
            XidImpl xid;
            byte[] globalId;
            byte recordType = buffer.get();
            if (recordType == 1) {
                if (!buffer.hasRemaining()) break;
                globalId = new byte[buffer.get()];
                if (buffer.limit() - buffer.position() < globalId.length) break;
                buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (recordMap.containsKey(xid)) {
                    throw new IOException("Tx start for same xid[" + xid + "] found twice");
                }
                recordList = new LinkedList<Record>();
                recordList.add(new Record(recordType, globalId, null, seqNr++));
                recordMap.put(xid, recordList);
                nextPosition += (long)(2 + globalId.length);
            } else if (recordType == 2) {
                if (buffer.limit() - buffer.position() < 2) break;
                globalId = new byte[buffer.get()];
                byte[] branchId = new byte[buffer.get()];
                if (buffer.limit() - buffer.position() < globalId.length + branchId.length) break;
                buffer.get(globalId);
                buffer.get(branchId);
                XidImpl xid2 = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid2)) {
                    throw new IOException("Branch[" + UTF8.decode(branchId) + "] found for [" + xid2 + "] but no record list found in map");
                }
                ((List)recordMap.get(xid2)).add(new Record(recordType, globalId, branchId, seqNr++));
                nextPosition += (long)(3 + globalId.length + branchId.length);
            } else if (recordType == 3) {
                if (!buffer.hasRemaining()) break;
                globalId = new byte[buffer.get()];
                if (buffer.limit() - buffer.position() < globalId.length) break;
                buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid)) {
                    throw new IOException("Commiting xid[" + xid + "] mark found but no record list found in map");
                }
                recordList = (List)recordMap.get(xid);
                recordList.add(new Record(recordType, globalId, null, seqNr++));
                recordMap.put(xid, recordList);
                nextPosition += (long)(2 + globalId.length);
            } else if (recordType == 4) {
                if (!buffer.hasRemaining()) break;
                globalId = new byte[buffer.get()];
                if (buffer.limit() - buffer.position() < globalId.length) break;
                buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid)) {
                    throw new IOException("Commiting xid[" + xid + "] mark found but no record list found in map");
                }
                recordMap.remove(xid);
                nextPosition += (long)(2 + globalId.length);
            } else {
                if (recordType == 0) continue;
                throw new IOException("Unknown type: " + recordType);
            }
            if (buffer.limit() - buffer.position() >= 131) continue;
            buffer.clear();
            fileChannel.position(nextPosition);
            fileChannel.read(buffer);
            buffer.flip();
        }
        return recordMap.values().iterator();
    }

    public synchronized void switchToLogFile(String newFile) throws IOException {
        if (newFile == null) {
            throw new IllegalArgumentException("Null filename");
        }
        this.force();
        Iterator<List<Record>> itr = this.getDanglingRecords();
        this.close();
        ArrayList records = new ArrayList();
        while (itr.hasNext()) {
            records.addAll(itr.next());
        }
        Collections.sort(records, new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return r1.getSequenceNumber() - r2.getSequenceNumber();
            }
        });
        Iterator recordItr = records.iterator();
        FileChannel fileChannel = this.fileSystem.open(newFile, "rw");
        fileChannel.position(fileChannel.size());
        this.logBuffer = new DirectMappedLogBuffer(fileChannel);
        this.name = newFile;
        this.truncate();
        while (recordItr.hasNext()) {
            Record record = (Record)recordItr.next();
            this.writeRecord(record, ForceMode.forced);
        }
        this.force();
    }

    public static class Record {
        private byte type = 0;
        private byte[] globalId = null;
        private byte[] branchId = null;
        private int seqNr = -1;

        Record(byte type, byte[] globalId, byte[] branchId, int seqNr) {
            if (type < 1 || type > 4) {
                throw new IllegalArgumentException("Illegal type: " + type);
            }
            this.type = type;
            this.globalId = globalId;
            this.branchId = branchId;
            this.seqNr = seqNr;
        }

        public byte getType() {
            return this.type;
        }

        public byte[] getGlobalId() {
            return this.globalId;
        }

        public byte[] getBranchId() {
            return this.branchId;
        }

        public int getSequenceNumber() {
            return this.seqNr;
        }

        public String toString() {
            XidImpl xid = new XidImpl(this.globalId, this.branchId == null ? new byte[]{} : this.branchId);
            return "TxLogRecord[" + this.typeName() + "," + xid + "," + this.seqNr + "]";
        }

        String typeName() {
            switch (this.type) {
                case 1: {
                    return "TX_START";
                }
                case 2: {
                    return "BRANCH_ADD";
                }
                case 3: {
                    return "MARK_COMMIT";
                }
                case 4: {
                    return "TX_DONE";
                }
            }
            return "<unknown type>";
        }
    }
}

