/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class Counter {
    public abstract void inc();

    public abstract long count();

    public static Counter atomic() {
        return new AtomicCounter();
    }

    private static class AtomicCounter
    extends Counter {
        private volatile long count;
        private static final AtomicLongFieldUpdater<AtomicCounter> COUNT = AtomicLongFieldUpdater.newUpdater(AtomicCounter.class, "count");

        private AtomicCounter() {
        }

        @Override
        public void inc() {
            COUNT.incrementAndGet(this);
        }

        @Override
        public long count() {
            return this.count;
        }
    }
}

