/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class AbstractGraphDatabase
implements GraphDatabaseService {
    private final String storeDir;
    private final StringLogger msgLog;

    protected AbstractGraphDatabase(String storeDir) {
        this.storeDir = FileUtils.canonicalize(storeDir);
        this.msgLog = this.createStringLogger();
    }

    protected StringLogger createStringLogger() {
        return StringLogger.logger(this.storeDir);
    }

    @Override
    public final void shutdown() {
        this.close();
        this.msgLog.close();
    }

    protected abstract void close();

    public final String getStoreDir() {
        return this.storeDir;
    }

    public abstract Config getConfig();

    public final StringLogger getMessageLog() {
        return this.msgLog;
    }

    @Override
    public Transaction beginTx() {
        return this.tx().begin();
    }

    public abstract TransactionBuilder tx();

    @Deprecated
    public final <T> T getManagementBean(Class<T> type) {
        return this.getSingleManagementBean(type);
    }

    public final <T> T getSingleManagementBean(Class<T> type) {
        Iterator<T> beans = this.getManagementBeans(type).iterator();
        if (beans.hasNext()) {
            T bean = beans.next();
            if (beans.hasNext()) {
                throw new NotFoundException("More than one management bean for " + type.getName());
            }
            return bean;
        }
        return null;
    }

    public abstract <T> Collection<T> getManagementBeans(Class<T> var1);

    public abstract KernelData getKernelData();

    protected boolean isEphemeral() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }
}

