/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;

public class NeoStore
extends AbstractStore {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final int RECORD_SIZE = 9;
    private static final int DEFAULT_REL_GRAB_SIZE = 100;
    public static final String DEFAULT_NAME = "neostore";
    private NodeStore nodeStore;
    private PropertyStore propStore;
    private RelationshipStore relStore;
    private RelationshipTypeStore relTypeStore;
    private final LastCommittedTxIdSetter lastCommittedTxIdSetter;
    private final IdGeneratorFactory idGeneratorFactory;
    private final TxHook txHook;
    private boolean isStarted;
    private long lastCommittedTx = -1L;
    private final int REL_GRAB_SIZE;

    public NeoStore(Map<?, ?> config) {
        super((String)config.get("neo_store"), config, IdType.NEOSTORE_BLOCK);
        String grabSize;
        int relGrabSize = 100;
        if (this.getConfig() != null && (grabSize = (String)this.getConfig().get("relationship_grab_size")) != null) {
            relGrabSize = Integer.parseInt(grabSize);
        }
        this.REL_GRAB_SIZE = relGrabSize;
        this.lastCommittedTxIdSetter = (LastCommittedTxIdSetter)config.get(LastCommittedTxIdSetter.class);
        this.idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        this.txHook = (TxHook)config.get(TxHook.class);
    }

    @Override
    protected void checkVersion() {
        try {
            String foundVersion;
            this.verifyCorrectTypeDescriptorAndVersion();
            if (!this.getStoreOk() && !"v0.A.0".equals(foundVersion = NeoStore.versionLongToString(NeoStore.getStoreVersion((String)this.getConfig().get("neo_store"))))) {
                throw new IllegalStateException(String.format("Mismatching store version found (%s while expecting %s) and the store is not cleanly shutdown. Recover the database with the previous database version and then attempt to upgrade", foundVersion, "v0.A.0"));
            }
        }
        catch (NotCurrentStoreVersionException e) {
            this.releaseFileLockAndCloseFileChannel();
            this.tryToUpgradeStores();
            this.checkStorage();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        super.verifyFileSizeAndTruncate();
        if (this.getFileChannel().size() == 45L) {
            this.insertRecord(5, -1L);
            this.registerIdFromUpdateRecord(5L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStorage() {
        this.instantiateChildStores();
        this.setRecovered();
        try {
            if (this.getCreationTime() != 0L && this.getStoreVersion() == 0L) {
                this.setStoreVersion(NeoStore.versionStringToLong("v0.A.0"));
                this.updateHighId();
            }
        }
        finally {
            this.unsetRecovered();
        }
    }

    private void instantiateChildStores() {
        this.relTypeStore = new RelationshipTypeStore(this.getStorageFileName() + ".relationshiptypestore.db", this.getConfig());
        this.propStore = new PropertyStore(this.getStorageFileName() + ".propertystore.db", this.getConfig());
        this.relStore = new RelationshipStore(this.getStorageFileName() + ".relationshipstore.db", this.getConfig());
        this.nodeStore = new NodeStore(this.getStorageFileName() + ".nodestore.db", this.getConfig());
    }

    private void tryToUpgradeStores() {
        new StoreUpgrader(this.getConfig(), new ConfigMapUpgradeConfiguration(this.getConfig()), new UpgradableDatabase(), new StoreMigrator(new VisibleMigrationProgressMonitor(System.out)), new DatabaseFiles()).attemptUpgrade(this.getStorageFileName());
    }

    private void insertRecord(int recordPosition, long value) throws IOException {
        try {
            FileChannel channel = this.getFileChannel();
            long previousPosition = channel.position();
            channel.position(9 * recordPosition);
            int trail = (int)(channel.size() - channel.position());
            ByteBuffer trailBuffer = null;
            if (trail > 0) {
                trailBuffer = ByteBuffer.allocate(trail);
                channel.read(trailBuffer);
                trailBuffer.flip();
            }
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put(Record.IN_USE.byteValue());
            buffer.putLong(value);
            buffer.flip();
            channel.position(9 * recordPosition);
            channel.write(buffer);
            if (trail > 0) {
                channel.write(trailBuffer);
            }
            channel.position(previousPosition);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeStorage() {
        if (this.lastCommittedTxIdSetter != null) {
            this.lastCommittedTxIdSetter.close();
        }
        if (this.relTypeStore != null) {
            this.relTypeStore.close();
            this.relTypeStore = null;
        }
        if (this.propStore != null) {
            this.propStore.close();
            this.propStore = null;
        }
        if (this.relStore != null) {
            this.relStore.close();
            this.relStore = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.close();
            this.nodeStore = null;
        }
    }

    @Override
    public void flushAll() {
        if (this.relTypeStore == null || this.propStore == null || this.relStore == null || this.nodeStore == null) {
            return;
        }
        this.relTypeStore.flushAll();
        this.propStore.flushAll();
        this.relStore.flushAll();
        this.nodeStore.flushAll();
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public TxHook getTxHook() {
        return this.txHook;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)config.get(FileSystemAbstraction.class);
        StoreId storeId = (StoreId)config.get(StoreId.class);
        if (storeId == null) {
            storeId = new StoreId();
        }
        NeoStore.createEmptyStore(fileName, NeoStore.buildTypeDescriptorAndVersion(TYPE_DESCRIPTOR), idGeneratorFactory, fileSystem);
        NodeStore.createStore(fileName + ".nodestore.db", config);
        RelationshipStore.createStore(fileName + ".relationshipstore.db", idGeneratorFactory, fileSystem);
        PropertyStore.createStore(fileName + ".propertystore.db", config);
        RelationshipTypeStore.createStore(fileName + ".relationshiptypestore.db", config);
        if (!config.containsKey("neo_store")) {
            HashMap newConfig = new HashMap(config);
            newConfig.put("neo_store", fileName);
            config = newConfig;
        }
        NeoStore neoStore = new NeoStore(config);
        for (int i = 0; i < 6; ++i) {
            neoStore.nextId();
        }
        neoStore.setCreationTime(storeId.getCreationTime());
        neoStore.setRandomNumber(storeId.getRandomId());
        neoStore.setVersion(0L);
        neoStore.setLastCommittedTx(1L);
        neoStore.setStoreVersion(storeId.getStoreVersion());
        neoStore.setGraphNextProp(-1L);
        neoStore.close();
    }

    public static long setVersion(String storeDir, long version) {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(new File(storeDir, DEFAULT_NAME), "rw");
            FileChannel channel = file.getChannel();
            channel.position(19L);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            channel.read(buffer);
            buffer.flip();
            long previous = buffer.getLong();
            channel.position(19L);
            buffer.clear();
            buffer.putLong(version).flip();
            channel.write(buffer);
            long l = previous;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static long getStoreVersion(String storeDir) {
        return NeoStore.getRecord(storeDir, 4L);
    }

    public static long getTxId(String storeDir) {
        return NeoStore.getRecord(storeDir, 3L);
    }

    private static long getRecord(String storeDir, long recordPosition) {
        RandomAccessFile file = null;
        try {
            long previous;
            file = new RandomAccessFile(new File(storeDir), "rw");
            FileChannel channel = file.getChannel();
            if (recordPosition > 3L && channel.size() < 45L) {
                long l = -1L;
                return l;
            }
            channel.position(9L * recordPosition + 1L);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            channel.read(buffer);
            buffer.flip();
            long l = previous = buffer.getLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getStoreVersion());
    }

    public long getCreationTime() {
        return this.getRecord(0L);
    }

    public void setCreationTime(long time) {
        this.setRecord(0L, time);
    }

    public long getRandomNumber() {
        return this.getRecord(1L);
    }

    public void setRandomNumber(long nr) {
        this.setRecord(1L, nr);
    }

    public void setRecoveredStatus(boolean status) {
        if (status) {
            this.setRecovered();
        } else {
            this.unsetRecovered();
        }
    }

    public long getVersion() {
        return this.getRecord(2L);
    }

    public void setVersion(long version) {
        this.setRecord(2L, version);
    }

    public synchronized void setLastCommittedTx(long txId) {
        long current = this.getRecord(3L);
        if (current + 1L != txId && !this.isInRecoveryMode()) {
            throw new InvalidRecordException("Could not set tx commit id[" + txId + "] since the current one is[" + current + "]");
        }
        this.setRecord(3L, txId);
        if (this.isStarted && this.lastCommittedTxIdSetter != null && txId != this.lastCommittedTx) {
            try {
                this.lastCommittedTxIdSetter.setLastCommittedTxId(txId);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Could not set last committed tx id", e);
            }
        }
        this.lastCommittedTx = txId;
    }

    public synchronized long getLastCommittedTx() {
        if (this.lastCommittedTx == -1L) {
            this.lastCommittedTx = this.getRecord(3L);
        }
        return this.lastCommittedTx;
    }

    public long incrementVersion() {
        long current = this.getVersion();
        this.setVersion(current + 1L);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecord(long id, long value) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.put(Record.IN_USE.byteValue()).putLong(value);
            this.registerIdFromUpdateRecord(id);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public long getStoreVersion() {
        return this.getRecord(4L);
    }

    public void setStoreVersion(long version) {
        this.setRecord(4L, version);
    }

    public long getGraphNextProp() {
        return this.getRecord(5L);
    }

    public void setGraphNextProp(long propId) {
        this.setRecord(5L, propId);
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public RelationshipStore getRelationshipStore() {
        return this.relStore;
    }

    public RelationshipTypeStore getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propStore;
    }

    @Override
    public void makeStoreOk() {
        this.relTypeStore.makeStoreOk();
        this.propStore.makeStoreOk();
        this.relStore.makeStoreOk();
        this.nodeStore.makeStoreOk();
        super.makeStoreOk();
        this.isStarted = true;
    }

    @Override
    public void rebuildIdGenerators() {
        this.relTypeStore.rebuildIdGenerators();
        this.propStore.rebuildIdGenerators();
        this.relStore.rebuildIdGenerators();
        this.nodeStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.updateHighId();
        this.relTypeStore.updateIdGenerators();
        this.propStore.updateIdGenerators();
        this.relStore.updateHighId();
        this.nodeStore.updateHighId();
    }

    public int getRelationshipGrabSize() {
        return this.REL_GRAB_SIZE;
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.addAll(this.nodeStore.getAllWindowPoolStats());
        list.addAll(this.propStore.getAllWindowPoolStats());
        list.addAll(this.relStore.getAllWindowPoolStats());
        list.addAll(this.relTypeStore.getAllWindowPoolStats());
        return list;
    }

    public boolean isStoreOk() {
        return this.getStoreOk() && this.relTypeStore.getStoreOk() && this.propStore.getStoreOk() && this.relStore.getStoreOk() && this.nodeStore.getStoreOk();
    }

    @Override
    public void logVersions(StringLogger.LineLogger logger) {
        super.logVersions(logger);
        this.nodeStore.logVersions(logger);
        this.relStore.logVersions(logger);
        this.relTypeStore.logVersions(logger);
        this.propStore.logVersions(logger);
    }

    public void logIdUsage(StringLogger.LineLogger msgLog) {
        this.nodeStore.logIdUsage(msgLog);
        this.relStore.logIdUsage(msgLog);
        this.relTypeStore.logIdUsage(msgLog);
        this.propStore.logIdUsage(msgLog);
    }

    public NeoStoreRecord asRecord() {
        NeoStoreRecord result = new NeoStoreRecord();
        result.setNextProp(this.getRecord(5L));
        return result;
    }

    public static void logIdUsage(StringLogger.LineLogger logger, Store store) {
        logger.logLine(String.format("%s: used=%s high=%s", store.getTypeDescriptor(), store.getNumberOfIdsInUse(), store.getHighestPossibleIdInUse()));
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Uknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits(8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put(c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Uknown";
        }
        Bits bits = Bits.bitsFromLongs(new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read in version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public static void main(String[] args) {
        long result = NeoStore.versionStringToLong("f123oo");
        String back = NeoStore.versionLongToString(result);
        System.out.println(result);
        System.out.println(back);
    }
}

