/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.info.SystemDiagnostics;

public final class DiagnosticsManager
implements Iterable<DiagnosticsProvider> {
    private final List<DiagnosticsProvider> providers = new CopyOnWriteArrayList<DiagnosticsProvider>();
    private final StringLogger logger;
    private volatile State state = State.INITIAL;

    public static final <T> Visitor<? super T> castToGenericVisitor(Class<T> type, Object visitor) {
        if (visitor instanceof Visitor) {
            for (Type iface : visitor.getClass().getGenericInterfaces()) {
                ParameterizedType paramType;
                if (!(iface instanceof ParameterizedType) || (paramType = (ParameterizedType)iface).getRawType() != Visitor.class) continue;
                return (Visitor)visitor;
            }
        }
        return null;
    }

    public DiagnosticsManager(StringLogger logger) {
        this.logger = logger;
        this.logger.addRotationListener(new Runnable(){

            @Override
            public void run() {
                DiagnosticsManager.this.dumpAll(DiagnosticsPhase.LOG_ROTATION);
            }
        });
        this.providers.add(new DiagnosticsProvider(){

            @Override
            public String getDiagnosticsIdentifier() {
                return DiagnosticsManager.this.getClass().getName();
            }

            @Override
            public void dump(DiagnosticsPhase phase, StringLogger log) {
                if (phase.isInitialization() || phase.isExplicitlyRequested()) {
                    log.logLongMessage("Diagnostics providers:", (Iterable<String>)new IterableWrapper<String, DiagnosticsProvider>((Iterable)DiagnosticsManager.this.providers){

                        @Override
                        protected String underlyingObjectToObject(DiagnosticsProvider provider) {
                            return provider.getDiagnosticsIdentifier();
                        }
                    }, true);
                }
            }

            @Override
            public void acceptDiagnosticsVisitor(Object visitor) {
                Visitor<DiagnosticsProvider> target = DiagnosticsManager.castToGenericVisitor(DiagnosticsProvider.class, visitor);
                if (target != null) {
                    for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                        target.visit(provider);
                    }
                }
            }
        });
        SystemDiagnostics.registerWith(this);
    }

    public StringLogger getTargetLog() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.startup(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.STARTUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.shutdown(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.SHUTDOWN);
        this.providers.clear();
    }

    public void dumpAll() {
        this.dumpAll(DiagnosticsPhase.REQUESTED);
    }

    public void dump(String identifier) {
        this.extract(identifier, this.logger);
    }

    public void extract(String identifier, StringLogger log) {
        for (DiagnosticsProvider provider : this.providers) {
            if (!identifier.equals(provider.getDiagnosticsIdentifier())) continue;
            provider.dump(DiagnosticsPhase.EXPLICIT, log);
            return;
        }
    }

    public void visitAll(Object visitor) {
        for (DiagnosticsProvider provider : this.providers) {
            provider.acceptDiagnosticsVisitor(visitor);
        }
    }

    private void dumpAll(DiagnosticsPhase phase) {
        phase.emitStart(this.logger);
        for (DiagnosticsProvider provider : this.providers) {
            provider.dump(phase, this.logger);
        }
        phase.emitDone(this.logger);
    }

    public <T> void register(DiagnosticsExtractor<T> extractor, T source) {
        this.appendProvider(DiagnosticsManager.extractedProvider(extractor, source));
    }

    public <T, E extends Enum<E>> void registerAll(Class<E> extractorEnum, T source) {
        for (Enum extractor : (Enum[])extractorEnum.getEnumConstants()) {
            this.register((DiagnosticsExtractor<T>)((Object)extractor), source);
        }
    }

    public void prependProvider(DiagnosticsProvider provider) {
        State state = this.state;
        if (state == State.STOPPED) {
            return;
        }
        this.providers.add(0, provider);
        if (state == State.STARTED) {
            this.dump(DiagnosticsPhase.STARTUP, provider);
        }
    }

    public void appendProvider(DiagnosticsProvider provider) {
        State state = this.state;
        if (state == State.STOPPED) {
            return;
        }
        this.providers.add(provider);
        if (state == State.STARTED) {
            this.dump(DiagnosticsPhase.STARTUP, provider);
        }
    }

    private void dump(DiagnosticsPhase phase, DiagnosticsProvider provider) {
        phase.emitStart(this.logger, provider);
        provider.dump(phase, this.logger);
        phase.emitDone(this.logger, provider);
    }

    @Override
    public Iterator<DiagnosticsProvider> iterator() {
        return this.providers.iterator();
    }

    static <T> DiagnosticsProvider extractedProvider(DiagnosticsExtractor<T> extractor, T source) {
        if (extractor instanceof DiagnosticsExtractor.VisitableDiagnostics) {
            return new ExtractedVisitableDiagnosticsProvider<T>((DiagnosticsExtractor.VisitableDiagnostics)extractor, source);
        }
        return new ExtractedDiagnosticsProvider<T>(extractor, source);
    }

    private static class ExtractedVisitableDiagnosticsProvider<T>
    extends ExtractedDiagnosticsProvider<T> {
        ExtractedVisitableDiagnosticsProvider(DiagnosticsExtractor.VisitableDiagnostics<T> extractor, T source) {
            super(extractor, source);
        }

        @Override
        public void acceptDiagnosticsVisitor(Object visitor) {
            ((DiagnosticsExtractor.VisitableDiagnostics)this.extractor).dispatchDiagnosticsVisitor(this.source, visitor);
        }
    }

    private static class ExtractedDiagnosticsProvider<T>
    implements DiagnosticsProvider {
        final DiagnosticsExtractor<T> extractor;
        final T source;

        ExtractedDiagnosticsProvider(DiagnosticsExtractor<T> extractor, T source) {
            this.extractor = extractor;
            this.source = source;
        }

        @Override
        public String getDiagnosticsIdentifier() {
            return this.extractor.toString();
        }

        @Override
        public void acceptDiagnosticsVisitor(Object visitor) {
        }

        @Override
        public void dump(DiagnosticsPhase phase, StringLogger log) {
            this.extractor.dumpDiagnostics(this.source, phase, log);
        }
    }

    private static enum State {
        INITIAL{

            @Override
            boolean startup(DiagnosticsManager manager) {
                manager.state = 1.STARTED;
                return true;
            }
        }
        ,
        STARTED,
        STOPPED{

            @Override
            boolean shutdown(DiagnosticsManager manager) {
                return false;
            }
        };


        boolean startup(DiagnosticsManager manager) {
            return false;
        }

        boolean shutdown(DiagnosticsManager manager) {
            manager.state = State.STOPPED;
            return true;
        }
    }
}

