/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Iterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.core.NodeManager;

public class GlobalGraphOperations {
    private final NodeManager nodeManager;

    private GlobalGraphOperations(GraphDatabaseService db) {
        if (!(db instanceof AbstractGraphDatabase)) {
            throw new IllegalArgumentException("Cannot get global operations at " + db.getClass());
        }
        this.nodeManager = ((AbstractGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager();
    }

    public static GlobalGraphOperations at(GraphDatabaseService db) {
        return new GlobalGraphOperations(db);
    }

    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllNodes();
            }
        };
    }

    public Iterable<Relationship> getAllRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllRelationships();
            }
        };
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }
}

