/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.tooling.wrap.WrappedEntity;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;
import org.neo4j.tooling.wrap.WrappedObject;

class WrappedEventHandler<T>
extends WrappedObject<TransactionEventHandler<T>>
implements TransactionEventHandler<T> {
    WrappedEventHandler(WrappedGraphDatabase graphdb, TransactionEventHandler<T> handler) {
        super(graphdb, handler);
    }

    @Override
    public T beforeCommit(TransactionData data) throws Exception {
        return ((TransactionEventHandler)this.wrapped).beforeCommit(new WrappedData(this.graphdb, data));
    }

    @Override
    public void afterCommit(TransactionData data, T state) {
        ((TransactionEventHandler)this.wrapped).afterCommit(new WrappedData(this.graphdb, data), state);
    }

    @Override
    public void afterRollback(TransactionData data, T state) {
        ((TransactionEventHandler)this.wrapped).afterRollback(new WrappedData(this.graphdb, data), state);
    }

    private static abstract class WrappedPropertyEntry<T extends PropertyContainer>
    extends WrappedObject<PropertyEntry<T>>
    implements PropertyEntry<T> {
        WrappedPropertyEntry(WrappedGraphDatabase graphdb, PropertyEntry<T> entry) {
            super(graphdb, entry);
        }

        @Override
        public String key() {
            return ((PropertyEntry)this.wrapped).key();
        }

        @Override
        public Object previouslyCommitedValue() {
            return ((PropertyEntry)this.wrapped).previouslyCommitedValue();
        }

        @Override
        public Object value() {
            return ((PropertyEntry)this.wrapped).value();
        }
    }

    private static class RelationshipPropertyEntry
    extends WrappedPropertyEntry<Relationship> {
        RelationshipPropertyEntry(WrappedGraphDatabase graphdb, PropertyEntry<Relationship> entry) {
            super(graphdb, entry);
        }

        @Override
        public Relationship entity() {
            return this.graphdb.relationship((Relationship)((PropertyEntry)this.wrapped).entity(), false);
        }
    }

    private static class NodePropertyEntry
    extends WrappedPropertyEntry<Node> {
        NodePropertyEntry(WrappedGraphDatabase graphdb, PropertyEntry<Node> entry) {
            super(graphdb, entry);
        }

        @Override
        public Node entity() {
            return this.graphdb.node((Node)((PropertyEntry)this.wrapped).entity(), false);
        }
    }

    private static class RelationshipProperties
    extends IterableWrapper<PropertyEntry<Relationship>, PropertyEntry<Relationship>> {
        private final WrappedGraphDatabase graphdb;

        RelationshipProperties(WrappedGraphDatabase graphdb, Iterable<PropertyEntry<Relationship>> iterable) {
            super(iterable);
            this.graphdb = graphdb;
        }

        @Override
        protected PropertyEntry<Relationship> underlyingObjectToObject(PropertyEntry<Relationship> object) {
            return new RelationshipPropertyEntry(this.graphdb, object);
        }
    }

    private static class NodeProperties
    extends IterableWrapper<PropertyEntry<Node>, PropertyEntry<Node>> {
        private final WrappedGraphDatabase graphdb;

        NodeProperties(WrappedGraphDatabase graphdb, Iterable<PropertyEntry<Node>> iterable) {
            super(iterable);
            this.graphdb = graphdb;
        }

        @Override
        protected PropertyEntry<Node> underlyingObjectToObject(PropertyEntry<Node> object) {
            return new NodePropertyEntry(this.graphdb, object);
        }
    }

    private static class WrappedData
    extends WrappedObject<TransactionData>
    implements TransactionData {
        WrappedData(WrappedGraphDatabase graphdb, TransactionData data) {
            super(graphdb, data);
        }

        @Override
        public Iterable<Node> createdNodes() {
            return this.graphdb.nodes(((TransactionData)this.wrapped).createdNodes());
        }

        @Override
        public Iterable<Node> deletedNodes() {
            return this.graphdb.nodes(((TransactionData)this.wrapped).deletedNodes());
        }

        @Override
        public boolean isDeleted(Node node) {
            return ((TransactionData)this.wrapped).isDeleted(WrappedEntity.unwrap(node));
        }

        @Override
        public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
            return new NodeProperties(this.graphdb, ((TransactionData)this.wrapped).assignedNodeProperties());
        }

        @Override
        public Iterable<PropertyEntry<Node>> removedNodeProperties() {
            return new NodeProperties(this.graphdb, ((TransactionData)this.wrapped).removedNodeProperties());
        }

        @Override
        public Iterable<Relationship> createdRelationships() {
            return this.graphdb.relationships(((TransactionData)this.wrapped).createdRelationships());
        }

        @Override
        public Iterable<Relationship> deletedRelationships() {
            return this.graphdb.relationships(((TransactionData)this.wrapped).deletedRelationships());
        }

        @Override
        public boolean isDeleted(Relationship relationship) {
            return ((TransactionData)this.wrapped).isDeleted(WrappedEntity.unwrap(relationship));
        }

        @Override
        public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
            return new RelationshipProperties(this.graphdb, ((TransactionData)this.wrapped).assignedRelationshipProperties());
        }

        @Override
        public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
            return new RelationshipProperties(this.graphdb, ((TransactionData)this.wrapped).removedRelationshipProperties());
        }
    }
}

