/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.kernel.ConfigurationPrefix;

public class ConfigProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(ConfigProxy.class.getName());
    private Map<String, String> parameters;

    public static <T> T config(Map<String, String> parameters, Class<T> configInterface) {
        return configInterface.cast(Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new ConfigProxy(parameters)));
    }

    public static Map<String, String> map(Object configuration) {
        return ((ConfigProxy)Proxy.getInvocationHandler((Object)configuration)).parameters;
    }

    public ConfigProxy(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String configName = method.getName();
        ConfigurationPrefix annotation = method.getDeclaringClass().getAnnotation(ConfigurationPrefix.class);
        String prefix = annotation == null ? "" : annotation.value();
        String key = prefix + configName;
        Object val = this.parameters.get(key);
        if (val == null) {
            if (args != null && args.length > 0) {
                return args[0];
            }
            throw new IllegalArgumentException("Missing configuration parameter for " + method.getDeclaringClass().getName() + ":" + key);
        }
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(val.getClass())) {
            block34: {
                try {
                    if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
                        val = val.toString().equalsIgnoreCase("true") || val.toString().equalsIgnoreCase("yes");
                        break block34;
                    }
                    if (returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
                        val = Integer.parseInt(val.toString());
                        break block34;
                    }
                    if (returnType.equals(Long.class) || returnType.equals(Long.TYPE)) {
                        val = Long.parseLong(val.toString());
                        break block34;
                    }
                    if (returnType.equals(Float.class) || returnType.equals(Float.TYPE)) {
                        val = Float.valueOf(Float.parseFloat(val.toString()));
                        break block34;
                    }
                    if (returnType.equals(Double.class) || returnType.equals(Double.TYPE)) {
                        val = Double.parseDouble(val.toString());
                        break block34;
                    }
                    if (!returnType.isEnum()) break block34;
                    try {
                        val = Enum.valueOf(returnType, val.toString().toLowerCase());
                    }
                    catch (IllegalArgumentException e) {
                        String options = Arrays.asList((Object[])returnType.getMethod("values", new Class[0]).invoke(null, new Object[0])).toString();
                        if (args != null && args.length > 0) {
                            log.warning("Value for configuration parameter '" + key + "' is not valid:" + val + ". Please use one of " + options + ". Using default instead:" + args[0]);
                            val = args[0];
                            break block34;
                        }
                        throw new IllegalArgumentException("Value for configuration parameter '" + key + "' is not valid:" + val + ". Please use one of " + options);
                    }
                }
                catch (NumberFormatException e) {
                    if (args != null && args.length > 0) {
                        log.warning("Number for configuration parameter '" + key + "' has wrong format:" + val + " Using default instead:" + args[0]);
                        val = args[0];
                    }
                    throw e;
                }
            }
            if (val instanceof Number && args != null && args.length == 3) {
                if (val instanceof Float) {
                    if (((Float)val).compareTo((Float)args[1]) < 0) {
                        val = args[1];
                    } else if (((Float)val).compareTo((Float)args[2]) > 0) {
                        val = args[2];
                    }
                } else if (val instanceof Double) {
                    if (((Double)val).compareTo((Double)args[1]) < 0) {
                        val = args[1];
                    } else if (((Double)val).compareTo((Double)args[2]) > 0) {
                        val = args[2];
                    }
                } else if (val instanceof Integer) {
                    if (((Integer)val).compareTo((Integer)args[1]) < 0) {
                        val = args[1];
                    } else if (((Integer)val).compareTo((Integer)args[2]) > 0) {
                        val = args[2];
                    }
                } else if (val instanceof Long) {
                    if (((Long)val).compareTo((Long)args[1]) < 0) {
                        val = args[1];
                    } else if (((Long)val).compareTo((Long)args[2]) > 0) {
                        val = args[2];
                    }
                }
            }
        }
        return val;
    }
}

