/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.reflect.Array;

public class SizeOfs {
    public static int sizeOf(String value) {
        return 52 + value.length() * 2;
    }

    public static int sizeOfArray(Object value) {
        int base;
        if (value instanceof String[]) {
            int size = 16;
            for (String string : (String[])value) {
                size += 8 + SizeOfs.sizeOf(string);
            }
            return size;
        }
        if (value instanceof byte[] || value instanceof boolean[]) {
            base = 1;
        } else if (value instanceof short[] || value instanceof char[]) {
            base = 2;
        } else if (value instanceof int[] || value instanceof float[]) {
            base = 4;
        } else if (value instanceof long[] || value instanceof double[]) {
            base = 8;
        } else if (value instanceof Byte[] || value instanceof Boolean[] || value instanceof Short[] || value instanceof Character[] || value instanceof Integer[] || value instanceof Float[] || value instanceof Long[] || value instanceof Double[]) {
            base = 8;
        } else {
            throw new IllegalStateException("Unkown type: " + value.getClass() + " [" + value + "]");
        }
        return 16 + base * Array.getLength(value);
    }
}

