/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.EntityWithSize;
import org.neo4j.kernel.impl.cache.HitCounter;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.SoftReferenceQueue;
import org.neo4j.kernel.impl.cache.SoftValue;

public class SoftLruCache<E extends EntityWithSize>
extends ReferenceCache<E> {
    private final ConcurrentHashMap<Long, SoftValue<Long, E>> cache = new ConcurrentHashMap();
    private final SoftReferenceQueue<Long, E> refQueue = new SoftReferenceQueue();
    private final String name;
    private final HitCounter counter = new HitCounter();

    public SoftLruCache(String name) {
        this.name = name;
    }

    @Override
    public void put(E value) {
        Long key = value.getId();
        SoftValue<Long, SoftValue> ref = new SoftValue<Long, SoftValue>(key, (SoftValue)value, this.refQueue);
        this.cache.put(key, ref);
        this.pollClearedValues();
    }

    @Override
    public void putAll(Collection<E> list) {
        HashMap<Long, SoftValue<Long, SoftValue>> softMap = new HashMap<Long, SoftValue<Long, SoftValue>>(list.size() * 2);
        for (EntityWithSize entry : list) {
            Long key = entry.getId();
            SoftValue<Long, SoftValue> ref = new SoftValue<Long, SoftValue>(key, (SoftValue)((Object)entry), this.refQueue);
            softMap.put(key, ref);
        }
        this.cache.putAll(softMap);
        this.pollClearedValues();
    }

    @Override
    public E get(long key) {
        SoftReference ref = this.cache.get(key);
        if (ref != null) {
            if (ref.get() == null) {
                this.cache.remove(key);
            }
            return (E)((EntityWithSize)this.counter.count(ref.get()));
        }
        return (E)((EntityWithSize)this.counter.count(null));
    }

    @Override
    public E remove(long key) {
        SoftReference ref = this.cache.remove(key);
        if (ref != null) {
            return (E)((EntityWithSize)ref.get());
        }
        return null;
    }

    @Override
    protected void pollClearedValues() {
        SoftValue<Long, E> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key);
            clearedValue = this.refQueue.safePoll();
        }
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }

    @Override
    public void updateSize(E entity, int sizeBefore, int sizeAfter) {
    }
}

