/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreMigrationTool {
    public static void main(String[] args) throws IOException {
        String legacyStoreDirectory = args[0];
        String targetStoreDirectory = args[1];
        new StoreMigrationTool().run(legacyStoreDirectory, targetStoreDirectory);
    }

    private void run(String legacyStoreDirectory, String targetStoreDirectory) throws IOException {
        LegacyStore legacyStore = new LegacyStore(new File(new File(legacyStoreDirectory), "neostore").getPath());
        HashMap<String, String> config = new HashMap<String, String>();
        File targetStoreDirectoryFile = new File(targetStoreDirectory);
        if (targetStoreDirectoryFile.exists()) {
            throw new IllegalStateException("Cannot migrate to a directory that already exists, please delete first and re-run");
        }
        boolean success = targetStoreDirectoryFile.mkdirs();
        if (!success) {
            throw new IllegalStateException("Failed to create directory");
        }
        File targetStoreFile = new File(targetStoreDirectory, "neostore");
        config.put("neo_store", targetStoreFile.getPath());
        NeoStore neoStore = new StoreFactory(config, CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultFileSystemAbstraction(), null, StringLogger.SYSTEM, null).createNeoStore(targetStoreFile.getPath());
        long startTime = System.currentTimeMillis();
        new StoreMigrator(new VisibleMigrationProgressMonitor(System.out)).migrate(legacyStore, neoStore);
        long duration = System.currentTimeMillis() - startTime;
        System.out.printf("Migration completed in %d s%n", duration / 1000L);
        neoStore.close();
        EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(targetStoreDirectoryFile.getPath());
        database.shutdown();
    }
}

