/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import javax.transaction.SystemException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.mockfs.LimitedFileSystemGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class RunOutOfDiskSpaceIT {
    public TargetDirectory targetDir = TargetDirectory.forTest(RunOutOfDiskSpaceIT.class);
    @Rule
    public TargetDirectory.TestDirectory testDir = this.targetDir.cleanTestDirectory();

    @Test
    public void shouldPropagateIOExceptions() throws Exception {
        TransactionFailureException exceptionThrown = null;
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase(this.testDir.directory().getAbsolutePath());
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.finish();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            exceptionThrown = e;
        }
        Assert.assertThat((Object)exceptionThrown.getCause(), (Matcher)Is.is(Throwable.class));
        Assert.assertThat((Object)exceptionThrown.getCause().getCause(), (Matcher)Is.is(Throwable.class));
        Assert.assertThat((Object)exceptionThrown.getCause().getCause().getCause(), (Matcher)Is.is(IOException.class));
    }

    @Test
    public void shouldStopDatabaseWhenOutOfDiskSpace() throws Exception {
        TransactionFailureException errorCaught = null;
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase(this.testDir.directory().getAbsolutePath());
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.finish();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
        try {
            db.beginTx();
            Assert.fail((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.");
        }
        catch (TransactionFailureException e) {
            errorCaught = e;
        }
        Assert.assertThat((Object)errorCaught.getCause(), (Matcher)Is.is(SystemException.class));
    }
}

