/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;

public class LimitedFileChannel
extends FileChannel {
    private final FileChannel inner;
    private LimitedFilesystemAbstraction fs;

    public LimitedFileChannel(FileChannel inner, LimitedFilesystemAbstraction limitedFilesystemAbstraction) {
        this.inner = inner;
        this.fs = limitedFilesystemAbstraction;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inner.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.read(byteBuffers, i, i1);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffers, i, i1);
    }

    @Override
    public long position() throws IOException {
        return this.inner.position();
    }

    @Override
    public FileChannel position(long l) throws IOException {
        return this.inner.position(l);
    }

    @Override
    public long size() throws IOException {
        return this.inner.size();
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        return this.inner.truncate(l);
    }

    @Override
    public void force(boolean b) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.force(b);
    }

    @Override
    public long transferTo(long l, long l1, WritableByteChannel writableByteChannel) throws IOException {
        return this.inner.transferTo(l, l1, writableByteChannel);
    }

    @Override
    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l1) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.transferFrom(readableByteChannel, l, l1);
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.read(byteBuffer, l);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.write(byteBuffer, l);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l1) throws IOException {
        return this.inner.map(mapMode, l, l1);
    }

    @Override
    public FileLock lock(long l, long l1, boolean b) throws IOException {
        return this.inner.lock(l, l1, b);
    }

    @Override
    public FileLock tryLock(long l, long l1, boolean b) throws IOException {
        return this.inner.tryLock(l, l1, b);
    }

    @Override
    protected void implCloseChannel() throws IOException {
    }
}

