/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.neo4j.graphdb.mockfs.LimitedFileChannel;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class LimitedFilesystemAbstraction
implements FileSystemAbstraction {
    private FileSystemAbstraction inner;
    private boolean outOfSpace;
    private Integer bytesAtATime = null;

    public LimitedFilesystemAbstraction(FileSystemAbstraction wrapped) {
        this.inner = wrapped;
    }

    public FileChannel open(String fileName, String mode) throws IOException {
        return new LimitedFileChannel(this.inner.open(fileName, mode), this);
    }

    public FileLock tryLock(String fileName, FileChannel channel) throws IOException {
        return this.inner.tryLock(fileName, channel);
    }

    public FileChannel create(String fileName) throws IOException {
        this.ensureHasSpace();
        return new LimitedFileChannel(this.inner.create(fileName), this);
    }

    public boolean fileExists(String fileName) {
        return this.inner.fileExists(fileName);
    }

    public long getFileSize(String fileName) {
        return this.inner.getFileSize(fileName);
    }

    public boolean deleteFile(String fileName) {
        return this.inner.deleteFile(fileName);
    }

    public boolean renameFile(String from, String to) throws IOException {
        this.ensureHasSpace();
        return this.inner.renameFile(from, to);
    }

    public void copyFile(String from, String to) throws IOException {
        this.ensureHasSpace();
        this.inner.copyFile(from, to);
    }

    public void runOutOfDiskSpace() {
        this.outOfSpace = true;
    }

    public void ensureHasSpace() throws IOException {
        if (this.outOfSpace) {
            throw new IOException("No space left on device");
        }
    }

    public void limitWritesTo(int bytesAtATime) {
        this.bytesAtATime = bytesAtATime;
    }
}

