/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.junit.Test;
import org.neo4j.helpers.collection.ExceptionHandlingIterable;
import org.neo4j.helpers.collection.IteratorUtil;

public class ExceptionHandlingIterableTest {
    @Test(expected=IllegalStateException.class)
    public void testHandleExceptionOnIteratorCreation() {
        IteratorUtil.count((Iterable)new ExceptionHandlingIterable(new Iterable(){

            public Iterator iterator() {
                throw new RuntimeException("exception on iterator");
            }
        }){

            protected Iterator exceptionOnIterator(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnIterator(t);
            }
        });
    }

    @Test(expected=IllegalStateException.class)
    public void testHandleExceptionOnNext() {
        IteratorUtil.count((Iterable)new ExceptionHandlingIterable(new Iterable(){

            public Iterator iterator() {
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    public Object next() {
                        throw new RuntimeException("exception on next");
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        }){

            protected Object exceptionOnNext(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnNext(t);
            }
        });
    }

    @Test(expected=IllegalStateException.class)
    public void testHandleExceptionOnHasNext() {
        IteratorUtil.count((Iterable)new ExceptionHandlingIterable(new Iterable(){

            public Iterator iterator() {
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        throw new RuntimeException("exception on next");
                    }

                    public Object next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        }){

            protected boolean exceptionOnHasNext(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnHasNext(t);
            }
        });
    }
}

