/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.ImpermanentGraphDatabase;

public class DiagnosticsLoggingTest {
    @Test
    public void shouldSeeHelloWorld() {
        FakeDatabase db = new FakeDatabase();
        FakeLogger logger = db.getLogger();
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Network information"));
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Disk space on partition"));
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Local timezone"));
        db.shutdown();
    }

    private class FakeDatabase
    extends ImpermanentGraphDatabase {
        private FakeDatabase() {
        }

        @Override
        protected Logging createStringLogger() {
            return new FakeLogger();
        }

        public FakeLogger getLogger() {
            return (FakeLogger)this.logging;
        }
    }

    private class FakeLogger
    extends StringLogger
    implements Logging {
        private StringBuilder messages = new StringBuilder();

        private FakeLogger() {
        }

        public String getMessages() {
            return this.messages.toString();
        }

        private void appendLine(String mess) {
            this.messages.append(mess).append("\n");
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger> source, boolean flush) {
            this.appendLine(msg);
            source.visit((Object)new StringLogger.LineLogger(){

                public void logLine(String line) {
                    FakeLogger.this.appendLine(line);
                }
            });
        }

        public void logMessage(String msg, boolean flush) {
            this.appendLine(msg);
        }

        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.appendLine(msg);
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.appendLine(line);
        }

        public StringLogger getLogger(String name) {
            if (name.equals("neo4j.diagnostics")) {
                return this;
            }
            return StringLogger.DEV_NULL;
        }
    }
}

