/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Exchanger;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;

public class RaceBetweenCommitAndGetMoreRelationshipsIT
extends TimerTask {
    private static final RelationshipType TYPE = DynamicRelationshipType.withName((String)"TYPE");
    private static RaceBetweenCommitAndGetMoreRelationshipsIT instance;
    private final GraphDatabaseService graphdb;
    private final NodeManager nodeManager;
    private final Timer timer;
    private final Exchanger<Throwable> error = new Exchanger();

    public static boolean exception(Throwable err) {
        RaceBetweenCommitAndGetMoreRelationshipsIT race = instance;
        if (race != null) {
            try {
                race.error.exchange(err);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private RaceBetweenCommitAndGetMoreRelationshipsIT(GraphDatabaseService graphdb, NodeManager nodeManager) {
        this.graphdb = graphdb;
        this.nodeManager = nodeManager;
        this.timer = new Timer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        String path = "target/commit-getMore-race";
        if (args != null && args.length >= 1) {
            path = args[0];
        }
        RaceBetweenCommitAndGetMoreRelationshipsIT.delete(new File(path));
        EmbeddedGraphDatabase graphdb = new EmbeddedGraphDatabase(path);
        RaceBetweenCommitAndGetMoreRelationshipsIT race = instance = new RaceBetweenCommitAndGetMoreRelationshipsIT((GraphDatabaseService)graphdb, graphdb.getNodeManager());
        try {
            race.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            graphdb.shutdown();
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                RaceBetweenCommitAndGetMoreRelationshipsIT.delete(child);
            }
        } else if (!file.exists()) {
            return;
        }
        file.delete();
    }

    private void execute() throws Throwable {
        this.setup(1000);
        this.nodeManager.clearCache();
        this.timer.schedule((TimerTask)this, 10L, 10L);
        Worker[] threads = new Worker[]{new Worker("writer", this.error){

            @Override
            void perform() {
                RaceBetweenCommitAndGetMoreRelationshipsIT.this.setup(100);
                if (RaceBetweenCommitAndGetMoreRelationshipsIT.assertions()) {
                    System.out.println("created 100");
                }
            }
        }, new Worker("reader", this.error){

            @Override
            void perform() {
                try {
                    int count = 0;
                    for (Relationship rel : RaceBetweenCommitAndGetMoreRelationshipsIT.this.graphdb.getReferenceNode().getRelationships()) {
                        ++count;
                    }
                    if (count % 100 != 0) {
                        throw new IllegalStateException("Not atomic!");
                    }
                    if (RaceBetweenCommitAndGetMoreRelationshipsIT.assertions()) {
                        System.out.println("counted relationships");
                    }
                }
                catch (InvalidRecordException ire) {
                    if (RaceBetweenCommitAndGetMoreRelationshipsIT.assertions()) {
                        ire.printStackTrace();
                    }
                    System.err.println((Object)ire);
                }
            }
        }};
        try {
            throw this.error.exchange(new Error("this should never see the light of day"));
        }
        catch (Throwable throwable) {
            this.cancel();
            for (Worker worker : threads) {
                worker.done();
            }
            throw throwable;
        }
    }

    private static boolean assertions() {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(int relCount) {
        Transaction tx = this.graphdb.beginTx();
        try {
            Node root = this.graphdb.getReferenceNode();
            for (int i = 0; i < relCount; ++i) {
                root.createRelationshipTo(this.graphdb.createNode(), TYPE);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void run() {
        this.nodeManager.clearCache();
        if (RaceBetweenCommitAndGetMoreRelationshipsIT.assertions()) {
            System.out.println("cleared cache");
        }
    }

    private static abstract class Worker
    extends Thread {
        private final Exchanger<Throwable> error;
        private volatile boolean done;

        Worker(String name, Exchanger<Throwable> error) {
            super(name);
            this.error = error;
            this.start();
        }

        void done() {
            if (this.done) {
                this.interrupt();
            }
            this.done = true;
        }

        @Override
        public void run() {
            try {
                while (!this.done) {
                    this.perform();
                }
            }
            catch (Throwable err) {
                this.done = true;
                try {
                    this.error.exchange(err);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        abstract void perform();
    }
}

