/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardOperationsCountException;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestGuard {
    @Test
    public void testGuardNotInsertedByDefault() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        Assert.assertNull((Object)db.getGuard());
        db.shutdown();
    }

    @Test
    public void testGuardInsertedByDefault() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((Setting)GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        Assert.assertNotNull((Object)db.getGuard());
        db.shutdown();
    }

    @Test
    public void testGuardOnDifferentGraphOps() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((Setting)GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        db.beginTx();
        db.getGuard().startOperationsCount(Integer.MAX_VALUE);
        db.createNode();
        db.createNode();
        db.createNode();
        Guard.OperationsCount ops1 = (Guard.OperationsCount)db.getGuard().stop();
        Assert.assertEquals((long)3L, (long)ops1.getOpsCount());
        db.getGuard().startOperationsCount(Integer.MAX_VALUE);
        Node n0 = db.getNodeById(0L);
        Node n1 = db.getNodeById(1L);
        Node n2 = db.getNodeById(2L);
        Node n3 = db.getNodeById(3L);
        Guard.OperationsCount ops2 = (Guard.OperationsCount)db.getGuard().stop();
        Assert.assertEquals((long)4L, (long)ops2.getOpsCount());
        db.getGuard().startOperationsCount(Integer.MAX_VALUE);
        n0.createRelationshipTo(n1, (RelationshipType)DynamicRelationshipType.withName((String)"REL"));
        Guard.OperationsCount ops3 = (Guard.OperationsCount)db.getGuard().stop();
        Assert.assertEquals((long)2L, (long)ops3.getOpsCount());
        db.getGuard().startOperationsCount(Integer.MAX_VALUE);
        for (Path position : Traversal.description().breadthFirst().relationships((RelationshipType)DynamicRelationshipType.withName((String)"REL")).traverse(n0)) {
        }
        Guard.OperationsCount ops4 = (Guard.OperationsCount)db.getGuard().stop();
        Assert.assertEquals((long)3L, (long)ops4.getOpsCount());
        db.shutdown();
    }

    @Test
    public void testOpsCountGuardFail() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((Setting)GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        db.beginTx();
        Guard guard = db.getGuard();
        guard.startOperationsCount(2L);
        Node n0 = db.getNodeById(0L);
        Node n1 = db.createNode();
        try {
            Node n2 = db.createNode();
            Assert.fail();
        }
        catch (GuardOperationsCountException e) {
            // empty catch block
        }
        db.shutdown();
    }

    @Test
    @Ignore
    public void testTimeoutGuardFail() throws InterruptedException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((Setting)GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        db.beginTx();
        db.getGuard().startTimeout(50L);
        int i = 0;
        try {
            for (i = 0; i < 1000; ++i) {
                db.createNode();
                Thread.sleep(1L);
            }
            Assert.fail();
        }
        catch (GuardTimeoutException guardTimeoutException) {
            // empty catch block
        }
        Assert.assertTrue((i > 1 ? 1 : 0) != 0);
        Assert.assertTrue((i < 100 ? 1 : 0) != 0);
        db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeoutGuardPass() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig((Setting)GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        db.beginTx();
        int timeout = 1000;
        db.getGuard().startTimeout((long)timeout);
        long startTime = System.currentTimeMillis();
        try {
            for (int i = 0; i < 1000; ++i) {
                db.createNode();
            }
        }
        catch (GuardTimeoutException e) {
            if (System.currentTimeMillis() - startTime < (long)timeout) {
                throw e;
            }
        }
        finally {
            db.shutdown();
        }
    }
}

