/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.PlaceboTransaction;

public class TestPlaceboTransaction {
    private TransactionManager mockTxManager;
    private Transaction mockTopLevelTx;
    private PlaceboTransaction placeboTx;

    @Before
    public void before() throws Exception {
        this.mockTxManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        this.mockTopLevelTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockTxManager.getTransaction()).thenReturn((Object)this.mockTopLevelTx);
        this.placeboTx = new PlaceboTransaction(this.mockTxManager);
    }

    @Test
    public void shouldRollbackParentByDefault() throws SystemException {
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }

    @Test
    public void shouldRollbackParentIfFailureCalled() throws SystemException {
        this.placeboTx.failure();
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }

    @Test
    public void shouldNotRollbackParentIfSuccessCalled() throws SystemException {
        this.placeboTx.success();
        this.placeboTx.finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTopLevelTx});
    }

    @Test
    public void successCannotOverrideFailure() throws Exception {
        this.placeboTx.failure();
        this.placeboTx.success();
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }
}

