/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestCacheTypes
extends AbstractNeo4jTestCase {
    private static final String PATH = TestCacheTypes.getStorePath("cache-db");

    @BeforeClass
    public static void clear() {
        TestCacheTypes.deleteFileOrDirectory(new File(PATH));
    }

    private GraphDatabaseAPI newDb(String cacheType) {
        return (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(PATH).setConfig(GraphDatabaseSettings.cache_type.name(), cacheType).newGraphDatabase();
    }

    @Test
    public void testDefaultCache() {
        GraphDatabaseAPI db = this.newDb(null);
        Assert.assertEquals((Object)"soft", (Object)db.getNodeManager().getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testWeakRefCache() {
        GraphDatabaseAPI db = this.newDb("weak");
        Assert.assertEquals((Object)"weak", (Object)db.getNodeManager().getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testSoftRefCache() {
        GraphDatabaseAPI db = this.newDb("soft");
        Assert.assertEquals((Object)"soft", (Object)db.getNodeManager().getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testNoCache() {
        GraphDatabaseAPI db = this.newDb("none");
        Assert.assertEquals((Object)"none", (Object)db.getNodeManager().getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testStrongCache() {
        GraphDatabaseAPI db = this.newDb("strong");
        Assert.assertEquals((Object)"strong", (Object)db.getNodeManager().getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testInvalidCache() {
        GraphDatabaseAPI db = null;
        try {
            db = this.newDb("whatever");
            Assert.fail((String)"Wrong cache type should not be allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

