/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.cache.LruCache;

public class TestLruCache {
    @Test
    public void testCreate() {
        try {
            new LruCache("TestCache", 0);
            Assert.fail((String)"Illegal maxSize should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        LruCache cache = new LruCache("TestCache", 70);
        try {
            cache.put(null, new Object());
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.put(new Object(), null);
            Assert.fail((String)"Null element should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.get(null);
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.remove(null);
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        cache.put(new Object(), new Object());
        cache.clear();
    }

    @Test
    public void testSimple() {
        LruCacheTest cache = new LruCacheTest("TestCache", 3);
        String s1 = new String("1");
        Integer key1 = new Integer(1);
        String s2 = new String("2");
        Integer key2 = new Integer(2);
        String s3 = new String("3");
        Integer key3 = new Integer(3);
        String s4 = new String("4");
        Integer key4 = new Integer(4);
        String s5 = new String("5");
        Integer key5 = new Integer(5);
        cache.put(key1, s1);
        cache.put(key2, s2);
        cache.put(key3, s3);
        cache.get(key2);
        Assert.assertEquals(null, (Object)cache.getLastCleanedElement());
        cache.put(key4, s4);
        Assert.assertEquals((Object)s1, (Object)cache.getLastCleanedElement());
        cache.put(key5, s5);
        Assert.assertEquals((Object)s3, (Object)cache.getLastCleanedElement());
        int size = cache.size();
        Assert.assertEquals((long)3L, (long)size);
        Assert.assertEquals(null, (Object)cache.get(key1));
        Assert.assertEquals((Object)s2, (Object)cache.get(key2));
        Assert.assertEquals(null, (Object)cache.get(key3));
        Assert.assertEquals((Object)s4, (Object)cache.get(key4));
        Assert.assertEquals((Object)s5, (Object)cache.get(key5));
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testResize() {
        LruCacheTest cache = new LruCacheTest("TestCache", 3);
        String s1 = new String("1");
        Integer key1 = new Integer(1);
        String s2 = new String("2");
        Integer key2 = new Integer(2);
        String s3 = new String("3");
        Integer key3 = new Integer(3);
        String s4 = new String("4");
        Integer key4 = new Integer(4);
        String s5 = new String("5");
        Integer key5 = new Integer(5);
        cache.put(key1, s1);
        cache.put(key2, s2);
        cache.put(key3, s3);
        cache.get(key2);
        Assert.assertEquals(null, (Object)cache.getLastCleanedElement());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(5);
        Assert.assertEquals((long)5L, (long)cache.maxSize());
        Assert.assertEquals((long)3L, (long)cache.size());
        cache.put(key4, s4);
        Assert.assertEquals(null, (Object)cache.getLastCleanedElement());
        cache.put(key5, s5);
        Assert.assertEquals(null, (Object)cache.getLastCleanedElement());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(4);
        Assert.assertEquals((Object)s1, (Object)cache.getLastCleanedElement());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(3);
        Assert.assertEquals((Object)s3, (Object)cache.getLastCleanedElement());
        Assert.assertEquals((long)3L, (long)cache.maxSize());
        Assert.assertEquals((long)3L, (long)cache.size());
    }

    private static class LruCacheTest<K, E>
    extends LruCache<K, E> {
        private Object cleanedElement = null;

        LruCacheTest(String name, int maxSize) {
            super(name, maxSize);
        }

        public void elementCleaned(E element) {
            this.cleanedElement = element;
        }

        Object getLastCleanedElement() {
            return this.cleanedElement;
        }
    }
}

