/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class AutoconfIT {
    @Test
    public void autoConfResultsInMoreMemoryForBiggerStore() throws Exception {
        String storeDir = TargetDirectory.forTest(this.getClass()).directory("db", true).getAbsolutePath();
        Map<Class<? extends Store>, Long> configForEmptyDb = this.getConfigForDb(storeDir);
        this.createBigDb(storeDir);
        Map<Class<? extends Store>, Long> configForBigDb = this.getConfigForDb(storeDir);
        for (Map.Entry<Class<? extends Store>, Long> entry : configForEmptyDb.entrySet()) {
            long bigDbValue = configForBigDb.get(entry.getKey());
            long dbValue = entry.getValue();
            Assert.assertTrue((String)String.format("%d > %d", bigDbValue, dbValue), (bigDbValue > dbValue ? 1 : 0) != 0);
        }
        long specificNodeBytes = 1234567L;
        Map<Class<? extends Store>, Long> configForSpecific = this.getConfigForDb(storeDir, MapUtil.stringMap((String[])new String[]{"neostore.nodestore.db.mapped_memory", "" + specificNodeBytes}));
        Assert.assertEquals((long)specificNodeBytes, (long)configForSpecific.get(NodeStore.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBigDb(String storeDir) {
        BatchInserterImpl inserter = new BatchInserterImpl(storeDir);
        try {
            inserter.createNode(200000000L, null);
        }
        finally {
            inserter.shutdown();
        }
    }

    private Map<Class<? extends Store>, Long> getConfigForDb(String storeDir) {
        return this.getConfigForDb(storeDir, MapUtil.stringMap((String[])new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<? extends Store>, Long> getConfigForDb(String storeDir, Map<String, String> config) {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir, config);
        try {
            StringBuffer dumpBuffer = new StringBuffer();
            StringLogger dumpLogger = StringLogger.wrap((StringBuffer)dumpBuffer);
            db.getDiagnosticsManager().extract(Config.class.getName(), dumpLogger);
            Map<String, String> readConfig = this.readDumpConfig(dumpBuffer.toString());
            Map map = MapUtil.genericMap((Object[])new Object[]{NodeStore.class, this.asBytes(readConfig, "neostore.nodestore.db.mapped_memory")});
            return map;
        }
        finally {
            db.shutdown();
        }
    }

    private Map<String, String> readDumpConfig(String dump) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : dump.split(Pattern.quote("\n"))) {
            int equalIndex = (line = line.trim()).indexOf(61);
            if (equalIndex <= 0) continue;
            map.put(line.substring(0, equalIndex).trim(), line.substring(equalIndex + 1, line.length()).trim());
        }
        return map;
    }

    private long asBytes(Map<String, String> readConfig, String key) {
        String conf = readConfig.get(key);
        if (conf == null) {
            return 0L;
        }
        int factor = 1;
        char lastChar = conf.charAt(conf.length() - 1);
        if (!Character.isDigit(lastChar)) {
            switch (Character.toUpperCase(lastChar)) {
                case 'M': {
                    factor = 0x100000;
                    break;
                }
                case 'G': {
                    factor = 0x40000000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown unit for '" + conf + "'");
                }
            }
            conf = conf.substring(0, conf.length() - 1);
        }
        return Long.parseLong(conf) * (long)factor;
    }
}

