/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class LoopRelTestIT {
    private static final Random r = new Random(System.currentTimeMillis());

    @Test
    public void runTheTests() throws Exception {
        TargetDirectory.recursiveDelete(new File("target/looprels"));
        LoopRelTestIT.main(new String[0]);
    }

    public static void main(String ... args) {
        for (int i = 0; i < 10; ++i) {
            EmbeddedGraphDatabase gdb = new EmbeddedGraphDatabase("target/looprels");
            ArrayList<Node> nodes = LoopRelTestIT.verifyOkDbAndSetup((GraphDatabaseService)gdb);
            LoopRelTestIT.doRandomStuff((GraphDatabaseService)gdb, 1000, nodes);
            gdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<Node> verifyOkDbAndSetup(GraphDatabaseService gdb) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)gdb).getAllNodes()) {
            allNodes.add(node);
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                rel.getOtherNode(node);
            }
        }
        Transaction tx = gdb.beginTx();
        try {
            while (allNodes.size() < 1000) {
                allNodes.add(gdb.createNode());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        return allNodes;
    }

    private static RelationshipType getRandomRelationshipType() {
        float f = r.nextFloat();
        if ((double)f < 0.33) {
            return DynamicRelationshipType.withName((String)"TEST1");
        }
        if ((double)f < 0.66) {
            return DynamicRelationshipType.withName((String)"TEST2");
        }
        return DynamicRelationshipType.withName((String)"TEST3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRandomStuff(GraphDatabaseService gdb, int count, ArrayList<Node> nodes) {
        Transaction tx = gdb.beginTx();
        try {
            for (int i = 0; i < count; ++i) {
                int index = r.nextInt(nodes.size());
                Node node = nodes.get(index);
                float op = r.nextFloat();
                if (op < 0.1f) {
                    node.createRelationshipTo(gdb.createNode(), LoopRelTestIT.getRandomRelationshipType());
                } else if (op < 0.25f) {
                    node.createRelationshipTo(node, LoopRelTestIT.getRandomRelationshipType());
                } else if (op < 0.75f) {
                    Node otherNode = nodes.get(r.nextInt(nodes.size()));
                    node.createRelationshipTo(otherNode, LoopRelTestIT.getRandomRelationshipType());
                } else if ((double)op < 0.95) {
                    for (Relationship rel : node.getRelationships()) {
                        if (!(r.nextFloat() < 0.25f)) continue;
                        rel.delete();
                    }
                } else if (nodes.size() > 100) {
                    for (Relationship rel : node.getRelationships()) {
                        rel.delete();
                    }
                    nodes.remove(index);
                    node.delete();
                }
                if (!(r.nextFloat() < 0.2f)) continue;
                tx.success();
                tx.finish();
                tx = gdb.beginTx();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

