/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.ImpermanentDatabaseRule;

public class TestConcurrentRelationshipChainLoadingIssue {
    private final int relCount = 2;
    @Rule
    public final ImpermanentDatabaseRule graphDb = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig((Setting)GraphDatabaseSettings.cache_type, "weak");
            builder.setConfig((Setting)GraphDatabaseSettings.relationship_grab_size, "1");
        }
    };

    @Test
    public void tryToTriggerRelationshipLoadingStoppingMidWay() throws Throwable {
        GraphDatabaseAPI db = this.graphDb.getGraphDatabaseAPI();
        Node node = this.createNodeWithRelationships(db);
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        while (System.currentTimeMillis() < end) {
            this.tryOnce(db, node);
        }
    }

    private void awaitStartSignalAndRandomTimeLonger(CountDownLatch startSignal) {
        try {
            startSignal.await();
            TestConcurrentRelationshipChainLoadingIssue.idleLoop((int)(System.currentTimeMillis() % 100000L));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryOnce(GraphDatabaseAPI db, final Node node) throws Throwable {
        db.getNodeManager().clearCache();
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch startSignal = new CountDownLatch(1);
        int threads = Runtime.getRuntime().availableProcessors();
        final AtomicReference error = new AtomicReference();
        for (int i = 0; i < threads; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    TestConcurrentRelationshipChainLoadingIssue.this.awaitStartSignalAndRandomTimeLonger(startSignal);
                    try {
                        Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)node.getRelationships()));
                    }
                    catch (Throwable e) {
                        error.set(e);
                    }
                }
            });
        }
        startSignal.countDown();
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        if (error.get() != null) {
            throw (Throwable)error.get();
        }
    }

    private static int idleLoop(int l) {
        int i = 0;
        for (int j = 0; j < l; ++j) {
            ++i;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeWithRelationships(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        try {
            int i;
            Node node = db.createNode();
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST2);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }
}

