/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestIdReuse {
    @Test
    public void makeSureIdsGetsReusedForPropertyStore() throws Exception {
        this.makeSureIdsGetsReused("neostore.propertystore.db", 10, 200);
    }

    @Test
    public void makeSureIdsGetsReusedForArrayStore() throws Exception {
        long[] array = new long[500];
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0xFFFFFFFFFFFFL + (long)i;
        }
        this.makeSureIdsGetsReused("neostore.propertystore.db.arrays", array, 20);
    }

    @Test
    public void makeSureIdsGetsReusedForStringStore() throws Exception {
        String string = "something";
        for (int i = 0; i < 100; ++i) {
            string = string + "something else " + i;
        }
        this.makeSureIdsGetsReused("neostore.propertystore.db.strings", string, 20);
    }

    private void makeSureIdsGetsReused(String fileName, Object value, int iterations) throws Exception {
        File storeDir = new File("target/var/idreuse");
        FileUtils.deleteRecursively((File)storeDir);
        File file = new File(storeDir, fileName);
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir.getAbsolutePath()).setConfig(GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false").newGraphDatabase();
        for (int i = 0; i < 5; ++i) {
            this.setSomeAndRemoveSome(db.getReferenceNode(), value);
        }
        db.shutdown();
        long sizeBefore = file.length();
        db = new GraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath());
        for (int i = 0; i < iterations; ++i) {
            this.setSomeAndRemoveSome(db.getReferenceNode(), value);
        }
        db.shutdown();
        Assert.assertEquals((long)sizeBefore, (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSomeAndRemoveSome(Node node, Object value) {
        int i;
        Transaction tx = node.getGraphDatabase().beginTx();
        try {
            for (i = 0; i < 10; ++i) {
                node.setProperty("key" + i, value);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = node.getGraphDatabase().beginTx();
        try {
            for (i = 0; i < 10; ++i) {
                node.removeProperty("key" + i);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

