/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.JumpingFileSystemAbstraction;
import org.neo4j.kernel.impl.core.JumpingIdGeneratorFactory;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;

public class TestJumpingIdGenerator {
    @Test
    public void testIt() throws Exception {
        int i;
        int sizePerJump = 1000;
        JumpingIdGeneratorFactory factory = new JumpingIdGeneratorFactory(sizePerJump);
        IdGenerator generator = factory.get(IdType.NODE);
        for (i = 0; i < sizePerJump / 2; ++i) {
            Assert.assertEquals((long)i, (long)generator.nextId());
        }
        for (i = 0; i < sizePerJump - 1; ++i) {
            long expected = 0x100000000L - (long)(sizePerJump / 2) + (long)i;
            if (expected >= 0xFFFFFFFFL) {
                ++expected;
            }
            Assert.assertEquals((long)expected, (long)generator.nextId());
        }
        for (i = 0; i < sizePerJump; ++i) {
            Assert.assertEquals((long)(0x200000000L - (long)(sizePerJump / 2) + (long)i), (long)generator.nextId());
        }
        for (i = 0; i < sizePerJump; ++i) {
            Assert.assertEquals((long)(0x300000000L - (long)(sizePerJump / 2) + (long)i), (long)generator.nextId());
        }
    }

    @Test
    public void testOffsettedFileChannel() throws Exception {
        int i;
        String fileName = "target/var/neostore.nodestore.db";
        AbstractNeo4jTestCase.deleteFileOrDirectory(fileName);
        JumpingFileSystemAbstraction offsettedFileSystem = new JumpingFileSystemAbstraction(10);
        IdGenerator idGenerator = new JumpingIdGeneratorFactory(10).get(IdType.NODE);
        JumpingFileSystemAbstraction.JumpingFileChannel channel = (JumpingFileSystemAbstraction.JumpingFileChannel)offsettedFileSystem.open(fileName, "rw");
        for (i = 0; i < 16; ++i) {
            this.writeSomethingLikeNodeRecord(channel, idGenerator.nextId(), i);
        }
        channel.close();
        channel = (JumpingFileSystemAbstraction.JumpingFileChannel)offsettedFileSystem.open(fileName, "rw");
        idGenerator = new JumpingIdGeneratorFactory(10).get(IdType.NODE);
        for (i = 0; i < 16; ++i) {
            Assert.assertEquals((long)i, (long)this.readSomethingLikeNodeRecord(channel, idGenerator.nextId()));
        }
        channel.close();
    }

    private byte readSomethingLikeNodeRecord(JumpingFileSystemAbstraction.JumpingFileChannel channel, long id) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        channel.position(id * 9L);
        channel.read(buffer);
        buffer.flip();
        buffer.getLong();
        return buffer.get();
    }

    private void writeSomethingLikeNodeRecord(JumpingFileSystemAbstraction.JumpingFileChannel channel, long id, int justAByte) throws IOException {
        channel.position(id * 9L);
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.putLong(4321L);
        buffer.put((byte)justAByte);
        buffer.flip();
        channel.write(buffer);
    }
}

