/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestNeo4j
extends AbstractNeo4jTestCase {
    @Test
    public void testReferenceNode() {
        Node oldReferenceNode = null;
        try {
            oldReferenceNode = this.getGraphDb().getReferenceNode();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Node newReferenceNode = this.getGraphDb().createNode();
        this.getNodeManager().setReferenceNodeId(newReferenceNode.getId());
        Assert.assertEquals((Object)newReferenceNode, (Object)this.getGraphDb().getReferenceNode());
        newReferenceNode.delete();
        if (oldReferenceNode != null) {
            this.getNodeManager().setReferenceNodeId(oldReferenceNode.getId());
            Assert.assertEquals((Object)oldReferenceNode, (Object)this.getGraphDb().getReferenceNode());
        }
    }

    @Test
    public void testBasicNodeRelationships() {
        Node firstNode = null;
        Node secondNode = null;
        Relationship rel = null;
        firstNode = this.getGraphDb().createNode();
        Assert.assertNotNull((String)"Failure creating first node", (Object)firstNode);
        secondNode = this.getGraphDb().createNode();
        Assert.assertNotNull((String)"Failure creating second node", (Object)secondNode);
        rel = firstNode.createRelationshipTo(secondNode, (RelationshipType)MyRelTypes.TEST);
        Assert.assertNotNull((String)"Relationship is null", (Object)rel);
        RelationshipType relType = rel.getType();
        Assert.assertNotNull((String)"Relationship's type is is null", (Object)relType);
        Assert.assertTrue((boolean)firstNode.getRelationships(new RelationshipType[]{relType}).iterator().hasNext());
        Assert.assertTrue((boolean)secondNode.getRelationships(new RelationshipType[]{relType}).iterator().hasNext());
        Iterable allRels = null;
        allRels = firstNode.getRelationships();
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, allRels));
        allRels = firstNode.getRelationships(new RelationshipType[]{relType});
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, allRels));
        allRels = secondNode.getRelationships();
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, allRels));
        allRels = secondNode.getRelationships(new RelationshipType[]{relType});
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, allRels));
        Object[] relNodes = rel.getNodes();
        Assert.assertEquals((String)"A relationship should always be connected to exactly two nodes", (long)relNodes.length, (long)2L);
        Assert.assertTrue((String)"Relationship says that it isn't connected to firstNode", (boolean)this.objectExistsInArray(firstNode, relNodes));
        Assert.assertTrue((String)"Relationship says that it isn't connected to secondNode", (boolean)this.objectExistsInArray(secondNode, relNodes));
        Assert.assertTrue((String)"The other node should be secondNode but it isn't", (boolean)rel.getOtherNode(firstNode).equals(secondNode));
        Assert.assertTrue((String)"The other node should be firstNode but it isn't", (boolean)rel.getOtherNode(secondNode).equals(firstNode));
        rel.delete();
        secondNode.delete();
        firstNode.delete();
    }

    private boolean objectExistsInIterable(Relationship rel, Iterable<Relationship> allRels) {
        for (Relationship iteratedRel : allRels) {
            if (!rel.equals(iteratedRel)) continue;
            return true;
        }
        return false;
    }

    private boolean objectExistsInArray(Object obj, Object[] objArray) {
        for (int i = 0; i < objArray.length; ++i) {
            if (!objArray[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testIdUsageInfo() {
        NodeManager nm = this.getEmbeddedGraphDb().getNodeManager();
        long nodeCount = nm.getNumberOfIdsInUse(Node.class);
        long relCount = nm.getNumberOfIdsInUse(Relationship.class);
        if (nodeCount > nm.getHighestPossibleIdInUse(Node.class)) {
            // empty if block
        }
        if (relCount > nm.getHighestPossibleIdInUse(Relationship.class)) {
            // empty if block
        }
        Node n1 = nm.createNode();
        Node n2 = nm.createNode();
        Relationship r1 = n1.createRelationshipTo(n2, (RelationshipType)MyRelTypes.TEST);
        r1.delete();
        n1.delete();
        n2.delete();
        this.getTransaction().success();
        this.getTransaction().finish();
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testRandomPropertyName() {
        Node node1 = this.getGraphDb().createNode();
        String key = "random_" + new Random(System.currentTimeMillis()).nextLong();
        node1.setProperty(key, (Object)"value");
        Assert.assertEquals((Object)"value", (Object)node1.getProperty(key));
        node1.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeChangePropertyArray() throws Exception {
        Node node;
        Transaction tx = this.getTransaction();
        tx.finish();
        tx = this.getGraphDb().beginTx();
        try {
            node = this.getGraphDb().createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = this.getGraphDb().beginTx();
        try {
            node.setProperty("test", (Object)new String[]{"value1"});
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = this.getGraphDb().beginTx();
        try {
            node.setProperty("test", (Object)new String[]{"value1", "value2"});
        }
        finally {
            tx.finish();
        }
        tx = this.getGraphDb().beginTx();
        try {
            String[] value = (String[])node.getProperty("test");
            Assert.assertEquals((long)1L, (long)value.length);
            Assert.assertEquals((Object)"value1", (Object)value[0]);
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testMultipleNeos() {
        String storePath = TestNeo4j.getStorePath("test-neo2");
        TestNeo4j.deleteFileOrDirectory(storePath);
        GraphDatabaseService graphDb2 = new GraphDatabaseFactory().newEmbeddedDatabase(storePath);
        Transaction tx2 = graphDb2.beginTx();
        this.getGraphDb().createNode();
        graphDb2.createNode();
        tx2.success();
        tx2.finish();
        graphDb2.shutdown();
    }

    @Test
    public void testGetAllNodes() {
        long highId = this.getNodeManager().getHighestPossibleIdInUse(Node.class);
        if (highId >= 0L && highId < 10000L) {
            int count = IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)this.getGraphDb()).getAllNodes());
            boolean found = false;
            Node newNode = this.getGraphDb().createNode();
            this.newTransaction();
            int oldCount = count;
            count = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.getGraphDb()).getAllNodes()) {
                ++count;
                if (!node.equals(newNode)) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
            Assert.assertEquals((long)count, (long)(oldCount + 1));
            Iterator allNodesIterator = GlobalGraphOperations.at((GraphDatabaseService)this.getGraphDb()).getAllNodes().iterator();
            Assert.assertNotNull(allNodesIterator.next());
            newNode.delete();
            this.newTransaction();
            found = false;
            count = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.getGraphDb()).getAllNodes()) {
                ++count;
                if (!node.equals(newNode)) continue;
                found = true;
            }
            Assert.assertTrue((!found ? 1 : 0) != 0);
            Assert.assertEquals((long)count, (long)oldCount);
        }
    }

    @Test
    public void testMultipleShutdown() {
        this.getGraphDb().shutdown();
        this.getGraphDb().shutdown();
    }
}

