/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

public class TestNeo4jApiExceptions
extends AbstractNeo4jTestCase {
    @Test
    public void testNotInTransactionException() {
        Node node1 = this.getGraphDb().createNode();
        node1.setProperty("test", (Object)1);
        Node node2 = this.getGraphDb().createNode();
        Node node3 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)11);
        this.commit();
        try {
            this.getGraphDb().createNode();
            Assert.fail((String)"Create node with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assert.fail((String)"Create relationship with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.setProperty("test", (Object)2);
            Assert.fail((String)"Set property with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.setProperty("test", (Object)22);
            Assert.fail((String)"Set property with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node3.delete();
            Assert.fail((String)"Delete node with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.delete();
            Assert.fail((String)"Delete relationship with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        this.newTransaction();
        Assert.assertEquals((Object)node1.getProperty("test"), (Object)1);
        Assert.assertEquals((Object)rel.getProperty("test"), (Object)11);
        Assert.assertEquals((Object)rel, (Object)node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        node1.delete();
        node2.delete();
        rel.delete();
        node3.delete();
    }

    @Test
    public void testNotFoundException() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        long nodeId = node1.getId();
        long relId = rel.getId();
        rel.delete();
        node2.delete();
        node1.delete();
        this.newTransaction();
        try {
            this.getGraphDb().getNodeById(nodeId);
            Assert.fail((String)"Get node by id on deleted node should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.getGraphDb().getRelationshipById(relId);
            Assert.fail((String)"Get relationship by id on deleted node should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }
}

