/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class TestOperationsOnDeletedPrimitive {
    private NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
    private PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
    Primitive primitive = new PrimitiveThatHasActuallyBeenDeleted(false);

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundOnGetPropertyWithDefaultOnDeletedEntity() throws Exception {
        this.primitive.getProperty(this.nodeManager, "the_property", new Object());
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnGetPropertyOnDeletedEntity() throws Exception {
        this.primitive.getProperty(this.nodeManager, "the_property");
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnSetPropertyOnDeletedEntity() throws Exception {
        this.primitive.setProperty(this.nodeManager, this.propertyContainer, "the_property", (Object)"the value");
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnRemovePropertyOnDeletedEntity() throws Exception {
        this.primitive.removeProperty(this.nodeManager, this.propertyContainer, "the_property");
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnGetPropertyKeysOnDeletedEntity() throws Exception {
        this.primitive.getPropertyKeys(this.nodeManager);
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnGetPropertyValuesOnDeletedEntity() throws Exception {
        this.primitive.getPropertyValues(this.nodeManager);
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnHasPropertyOnDeletedEntity() throws Exception {
        this.primitive.hasProperty(this.nodeManager, "the_property");
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnGetAllCommittedPropertiesOnDeletedEntity() throws Exception {
        this.primitive.getAllCommittedProperties(this.nodeManager);
    }

    @Test(expected=NotFoundException.class)
    public void shouldThrowNotFoundExceptionOnGetCommittedPropertyValueOnDeletedEntity() throws Exception {
        this.primitive.getCommittedPropertyValue(this.nodeManager, "the_key");
    }

    private class PrimitiveThatHasActuallyBeenDeleted
    extends Primitive {
        PrimitiveThatHasActuallyBeenDeleted(boolean newPrimitive) {
            super(newPrimitive);
        }

        protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
            throw new InvalidRecordException("I have been deleted, remember!");
        }

        protected PropertyData changeProperty(NodeManager nodeManager, PropertyData property, Object value) {
            return null;
        }

        protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
            return null;
        }

        protected void removeProperty(NodeManager nodeManager, PropertyData property) {
        }

        public long getId() {
            return 0L;
        }

        protected void setEmptyProperties() {
        }

        protected PropertyData[] allProperties() {
            return null;
        }

        protected PropertyData getPropertyForIndex(int keyId) {
            return null;
        }

        protected void setProperties(ArrayMap<Integer, PropertyData> properties, NodeManager nodeManager) {
        }

        protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp, NodeManager nodeManager) {
        }

        public LockReleaser.CowEntityElement getEntityElement(LockReleaser.PrimitiveElement element, boolean create) {
            return null;
        }

        PropertyContainer asProxy(NodeManager nm) {
            PropertyContainer mockContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
            Mockito.when((Object)mockContainer.toString()).thenReturn((Object)"MockedEntity[1337]");
            return mockContainer;
        }
    }
}

