/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.util.RelIdArray;

public class TestOperationsOnDeletedRelationships {
    @Test
    public void shouldThrowNotFoundOnGetAllRelationshipsWhenRelationshipConcurrentlyDeleted() throws Exception {
        NodeImpl nodeImpl = new NodeImpl(1337L, 0L, 0L, false);
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Throwable exceptionCaught = null;
        Mockito.when((Object)nodeManager.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        try {
            nodeImpl.getAllRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH);
        }
        catch (Throwable e) {
            exceptionCaught = e;
        }
        Assert.assertThat((Object)exceptionCaught, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)exceptionCaught, (Matcher)CoreMatchers.is(NotFoundException.class));
    }

    @Test
    public void shouldThrowNotFoundWhenIteratingOverDeletedRelationship() throws Exception {
        NodeImpl fromNode = new NodeImpl(1337L, 0L, 0L, false);
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Throwable exceptionCaught = null;
        fromNode.setRelChainPosition(1337L);
        Mockito.when((Object)nodeManager.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        try {
            fromNode.getMoreRelationships(nodeManager);
        }
        catch (Throwable e) {
            exceptionCaught = e;
        }
        Assert.assertThat((Object)exceptionCaught, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)exceptionCaught, (Matcher)CoreMatchers.is(NotFoundException.class));
    }
}

