/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.CountDownLatch;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.nioneo.xa.Command$NodeCommand", method="execute", on=BreakPoint.Event.ENTRY), @ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.nioneo.xa.WriteTransaction", method="applyCommit", on=BreakPoint.Event.ENTRY)})
@RunWith(value=SubProcessTestRunner.class)
public class TestTxApplicationSynchronization {
    private EmbeddedGraphDatabase baseDb;
    private EmbeddedGraphDatabase targetDb;
    private long nodeId;
    private static DebuggedThread updater;
    private static final CountDownLatch latch;

    @Before
    public void before() throws Exception {
        TargetDirectory dir = TargetDirectory.forTest(this.getClass());
        this.baseDb = new EmbeddedGraphDatabase(dir.directory("base", true).getAbsolutePath());
        Transaction tx = this.baseDb.beginTx();
        Node node = this.baseDb.createNode();
        this.nodeId = node.getId();
        node.setProperty("propName", (Object)"propValue");
        tx.success();
        tx.finish();
        this.targetDb = new EmbeddedGraphDatabase(dir.directory("target", true).getAbsolutePath());
        Pair<Long, ReadableByteChannel> lastTx = TestTxApplicationSynchronization.getLatestCommitedTx(this.baseDb);
        NeoStoreXaDataSource targetNeoDatasource = this.targetDb.getXaDataSourceManager().getNeoStoreDataSource();
        targetNeoDatasource.applyCommittedTransaction(((Long)lastTx.first()).longValue(), (ReadableByteChannel)lastTx.other());
    }

    @Test
    @EnabledBreakpoints(value={"applyCommit", "waitForSuspend", "resumeAll"})
    public void test() throws Exception {
        Transaction tx = this.baseDb.beginTx();
        this.baseDb.getNodeById(this.nodeId).removeProperty("propName");
        tx.success();
        tx.finish();
        final CountDownLatch localLatch = new CountDownLatch(1);
        Thread updatePuller = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Pair lastTx = TestTxApplicationSynchronization.getLatestCommitedTx(TestTxApplicationSynchronization.this.baseDb);
                    NeoStoreXaDataSource targetNeoDatasource = TestTxApplicationSynchronization.this.targetDb.getXaDataSourceManager().getNeoStoreDataSource();
                    localLatch.countDown();
                    targetNeoDatasource.applyCommittedTransaction(((Long)lastTx.first()).longValue(), (ReadableByteChannel)lastTx.other());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, "writer");
        updatePuller.start();
        Thread.sleep(100L);
        localLatch.await();
        this.waitForSuspend();
        this.targetDb.getNodeById(this.nodeId).getProperty("propName");
        this.resumeAll();
        updatePuller.join();
    }

    @BreakpointTrigger(value="waitForSuspend")
    private void waitForSuspend() {
    }

    @BreakpointTrigger(value="resumeAll")
    private void resumeAll() {
    }

    @BreakpointHandler(value={"waitForSuspend"})
    public static void suspendHandler(BreakPoint self, DebugInterface di) throws Exception {
        latch.await();
    }

    @BreakpointHandler(value={"resumeAll"})
    public static void resumeAllHandler(BreakPoint self, DebugInterface di) {
        if (updater != null) {
            updater.resume();
        }
    }

    @BreakpointHandler(value={"applyCommit"})
    public static void onCommitRecovered(BreakPoint self, DebugInterface di, @BreakpointHandler(value={"execute"}) BreakPoint commandExecute) {
        Boolean isRecovered = (Boolean)di.getLocalVariable("isRecovered");
        if (isRecovered.booleanValue()) {
            if (self.invocationCount() > 1) {
                commandExecute.enable();
            }
        } else {
            self.invocationCount(self.invocationCount() - 1);
        }
    }

    @BreakpointHandler(value={"execute"})
    public static void handleExecute(BreakPoint self, DebugInterface di) {
        updater = di.thread();
        updater.suspend(null);
        latch.countDown();
    }

    private static Pair<Long, ReadableByteChannel> getLatestCommitedTx(EmbeddedGraphDatabase db) throws Exception {
        NeoStoreXaDataSource neoDatasource = db.getXaDataSourceManager().getNeoStoreDataSource();
        long lastCommittedTxId = neoDatasource.getLastCommittedTxId();
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        neoDatasource.getLogExtractor(lastCommittedTxId, lastCommittedTxId).extractNext((LogBuffer)buffer);
        return Pair.of((Object)lastCommittedTxId, (Object)buffer);
    }

    static {
        latch = new CountDownLatch(1);
    }
}

