/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Scanner;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.event.IllBehavingXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class TestKernelPanic {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void panicTest() throws Exception {
        String path = "target/var/testdb";
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(path));
        GraphDatabaseService graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(path);
        XaDataSourceManager xaDs = ((GraphDatabaseAPI)graphDb).getXaDataSourceManager();
        IllBehavingXaDataSource noob = new IllBehavingXaDataSource(UTF8.encode((String)"554342"), "noob");
        xaDs.registerDataSource((XaDataSource)noob);
        Panic panic = new Panic();
        graphDb.registerKernelEventHandler((KernelEventHandler)panic);
        org.neo4j.graphdb.Transaction gdbTx = graphDb.beginTx();
        TransactionManager txMgr = ((GraphDatabaseAPI)graphDb).getTxManager();
        Transaction tx = txMgr.getTransaction();
        graphDb.createNode();
        noob.getXaConnection().enlistResource(tx);
        try {
            gdbTx.success();
            gdbTx.finish();
            Assert.fail((String)"Should fail");
        }
        catch (Throwable t) {
            for (int i = 0; i < 10 && !panic.panic; ++i) {
                Thread.sleep(1000L);
            }
        }
        finally {
            graphDb.unregisterKernelEventHandler((KernelEventHandler)panic);
        }
        Assert.assertTrue((boolean)panic.panic);
        this.assertMessageLogContains(path, "at org.neo4j.kernel.impl.event.TestKernelPanic.panicTest");
        graphDb.shutdown();
    }

    private void assertMessageLogContains(String path, String exceptionString) throws FileNotFoundException {
        File logFile = new File(path, "messages.log");
        Assert.assertTrue((String)("exists " + logFile), (logFile.exists() && logFile.isFile() ? 1 : 0) != 0);
        Scanner scanner = new Scanner(logFile).useDelimiter("\n");
        for (String line : IteratorUtil.asIterable((Iterator)scanner)) {
            if (!line.contains(exceptionString)) continue;
            return;
        }
        Assert.fail((String)(logFile + " did not contain: " + exceptionString));
    }

    private static class Panic
    implements KernelEventHandler {
        boolean panic = false;

        private Panic() {
        }

        public void beforeShutdown() {
        }

        public Object getResource() {
            return null;
        }

        public void kernelPanic(ErrorState error) {
            this.panic = true;
        }

        public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
            return null;
        }
    }
}

