/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.index.IndexProviderStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestIndexProviderStore {
    private File file;
    private FileSystemAbstraction fileSystem;

    @Before
    public void createStore() {
        this.file = new File("target/test-data/index-provider-store");
        this.fileSystem = new DefaultFileSystemAbstraction();
        this.file.mkdirs();
        this.file.delete();
    }

    @Test
    public void lastCommitedTxGetsStoredBetweenSessions() throws Exception {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        store.setVersion(5L);
        store.setLastCommittedTx(12L);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        Assert.assertEquals((long)5L, (long)store.getVersion());
        Assert.assertEquals((long)12L, (long)store.getLastCommittedTx());
        store.close();
    }

    @Test
    public void shouldFailUpgradeIfNotAllowed() {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), true);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), false);
        store.close();
        try {
            new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), false);
            Assert.fail((String)"Shouldn't be able to upgrade there");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), true);
        Assert.assertEquals((Object)"3.5", (Object)NeoStore.versionLongToString((long)store.getIndexVersion()));
        store.close();
    }

    @Test(expected=NotCurrentStoreVersionException.class)
    public void shouldFailToGoBackToOlderVersion() throws Exception {
        String newerVersion = "3.5";
        String olderVersion = "3.1";
        try {
            IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)newerVersion), true);
            store.close();
            store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)olderVersion), false);
        }
        catch (NotCurrentStoreVersionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(newerVersion));
            Assert.assertTrue((boolean)e.getMessage().contains(olderVersion));
            throw e;
        }
    }

    @Test(expected=NotCurrentStoreVersionException.class)
    public void shouldFailToGoBackToOlderVersionEvenIfAllowUpgrade() throws Exception {
        String newerVersion = "3.5";
        String olderVersion = "3.1";
        try {
            IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)newerVersion), true);
            store.close();
            store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)olderVersion), true);
        }
        catch (NotCurrentStoreVersionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(newerVersion));
            Assert.assertTrue((boolean)e.getMessage().contains(olderVersion));
            throw e;
        }
    }

    @Test
    public void upgradeForMissingVersionRecord() throws Exception {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        store.close();
        FileUtils.truncateFile((File)this.file, (long)32L);
        try {
            store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
            Assert.fail((String)"Should have thrown upgrade exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
        store = new IndexProviderStore(this.file, this.fileSystem, 0L, true);
        store.close();
    }
}

