/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Random;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Written as a reaction to an observed bug, but it doesn't seem to trigger it though")
public class LargeByteArraysIT {
    private static final Random RANDOM = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void largeByteArrays() throws Exception {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(TargetDirectory.forTest(this.getClass()).directory("bytearrays", true).getAbsolutePath());
        try {
            for (int i = 0; i < 100000; ++i) {
                this.createNodeWithBigArray(db);
                if (i <= 0 || i % 100 != 0) continue;
                System.out.println(i);
            }
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNodeWithBigArray(EmbeddedGraphDatabase db) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("prop", (Object)this.randomBigByteArray());
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private byte[] randomBigByteArray() {
        byte[] array = new byte[Math.max(248, RANDOM.nextInt(253952))];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)(System.currentTimeMillis() % 255L);
        }
        return array;
    }

    private void setLogSize(EmbeddedGraphDatabase db) {
        db.getXaDataSourceManager().getNeoStoreDataSource().setLogicalLogTargetSize(0x200000L);
    }
}

