/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.MappedPersistenceWindowTest;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ResourceCollection;
import org.neo4j.test.TargetDirectory;

public class PersistenceWindowPoolTest {
    private static final TargetDirectory target = TargetDirectory.forTest(MappedPersistenceWindowTest.class);
    @Rule
    public final TargetDirectory.TestDirectory directory = target.testDirectory();
    @Rule
    public final ResourceCollection resources = new ResourceCollection();

    @Test
    public void shouldBeAbleToReAcquireReleasedWindow() throws Exception {
        String filename = new File(this.directory.directory(), "mapped.file").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        PersistenceWindowPool pool = new PersistenceWindowPool("test.store", 8, file.getChannel(), 0L, false, false, StringLogger.DEV_NULL);
        PersistenceWindow initialWindow = pool.acquire(0L, OperationType.READ);
        pool.release(initialWindow);
        PersistenceWindow window = pool.acquire(0L, OperationType.READ);
        Assert.assertNotSame((Object)initialWindow, (Object)window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void handOverDirtyPersistenceRowToReaderShouldWriteWhenClosing() throws Exception {
        String filename = new File(target.graphDbDir(true), "dirty").getAbsolutePath();
        RandomAccessFile file = this.resources.add(new RandomAccessFile(filename, "rw"));
        int blockSize = 8;
        final PersistenceWindowPool pool = new PersistenceWindowPool("test.store", 8, file.getChannel(), 0L, false, false, StringLogger.DEV_NULL);
        final PersistenceWindow t1Row = pool.acquire(0L, OperationType.WRITE);
        OtherThreadExecutor<Object> otherThread = new OtherThreadExecutor<Object>(null);
        Future<Throwable> future = otherThread.executeDontWait(new OtherThreadExecutor.WorkerCommand<Void, Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Throwable doWork(Void state) {
                PersistenceWindow t2Row = pool.acquire(0L, OperationType.READ);
                try {
                    Assert.assertTrue((t1Row == t2Row ? 1 : 0) != 0);
                    PersistenceWindowPoolTest.this.assertBufferContents(8, t2Row);
                    Throwable throwable = null;
                    return throwable;
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                    return throwable;
                }
                finally {
                    pool.release(t2Row);
                }
            }
        });
        try {
            this.writeBufferContents(8, t1Row);
            otherThread.waitUntilWaiting();
        }
        finally {
            pool.release(t1Row);
        }
        Throwable failure = future.get();
        if (failure != null) {
            throw Exceptions.launderedException((Throwable)failure);
        }
        PersistenceWindow row = pool.acquire(0L, OperationType.READ);
        Assert.assertFalse((t1Row == row ? 1 : 0) != 0);
        this.assertBufferContents(8, row);
        pool.close();
        otherThread.shutdown();
    }

    private void writeBufferContents(int blockSize, PersistenceWindow t1Row) {
        Buffer buffer = t1Row.getBuffer();
        for (int i = 0; i < blockSize; ++i) {
            buffer.put((byte)i);
        }
    }

    private void assertBufferContents(int blockSize, PersistenceWindow row) {
        Buffer buffer = row.getBuffer();
        for (int i = 0; i < blockSize; ++i) {
            Assert.assertEquals((long)((byte)i), (long)buffer.get());
        }
    }
}

