/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.junit.Assert;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.ProcessStreamHandler;

public class ProduceUncleanStore {
    public static void main(String[] args) throws Exception {
        String storeDir = args[0];
        boolean setGraphProperty = args.length > 1 ? Boolean.parseBoolean(args[1]) : false;
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir){

            protected Logging createStringLogger() {
                return new DevNullLoggingService();
            }
        };
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        if (setGraphProperty) {
            ((GraphDatabaseAPI)db).getNodeManager().getGraphProperties().setProperty("prop", (Object)"Some value");
        }
        tx.success();
        tx.finish();
        System.exit(0);
    }

    public static void atPath(File path) throws Exception {
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), path.getAbsolutePath()});
        int ret = new ProcessStreamHandler(process, true).waitForResult();
        Assert.assertEquals((String)"ProduceUncleanStore terminated unsuccessfully", (long)0L, (long)ret);
    }
}

