/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class TestArrayStore {
    private File dir;
    private DynamicArrayStore arrayStore;

    @Before
    public void before() throws Exception {
        this.dir = TargetDirectory.forTest(this.getClass()).directory("db", true);
        Map configParams = MapUtil.stringMap((String[])new String[0]);
        Config config = new Config(configParams);
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        StoreFactory factory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)fs, (LastCommittedTxIdSetter)new DefaultLastCommittedTxIdSetter(), StringLogger.DEV_NULL, (TxHook)new DefaultTxHook());
        String fileName = new File(this.dir, "arraystore").getAbsolutePath();
        factory.createDynamicArrayStore(fileName, 120);
        this.arrayStore = new DynamicArrayStore(fileName, config, IdType.ARRAY_BLOCK, (IdGeneratorFactory)idGeneratorFactory, (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)fs, StringLogger.DEV_NULL);
    }

    @After
    public void after() throws Exception {
        if (this.arrayStore != null) {
            this.arrayStore.close();
        }
    }

    @Test
    public void intArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7}, PropertyType.INT, 3, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1, 2, 3, 4, 5, 6, 7, 8}, PropertyType.INT, 4, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new int[]{1000, 10000, 13000}, PropertyType.INT, 14, 2);
    }

    @Test
    public void longArrayPropertiesShouldBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, PropertyType.LONG, 3, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}, PropertyType.LONG, 4, 1);
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new long[]{1000L, 10000L, 13000L, 15000000000L}, PropertyType.LONG, 34, 2);
    }

    @Test
    public void byteArrayPropertiesShouldNotBeBitPacked() throws Exception {
        this.assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(new byte[]{1, 2, 3, 4, 5}, PropertyType.BYTE, 8, 1);
    }

    @Test
    public void stringArrayGetsStoredAsUtf8() throws Exception {
        String[] array = new String[]{"first", "second"};
        Collection records = this.arrayStore.allocateRecords(this.arrayStore.nextBlockId(), (Object)array);
        Pair<byte[], byte[]> loaded = this.loadArray(records);
        this.assertStringHeader((byte[])loaded.first(), array.length);
        ByteBuffer buffer = ByteBuffer.wrap((byte[])loaded.other());
        for (String item : array) {
            byte[] expectedData = UTF8.encode((String)item);
            junit.framework.Assert.assertEquals((int)expectedData.length, (int)buffer.getInt());
            byte[] loadedItem = new byte[expectedData.length];
            buffer.get(loadedItem);
            Assert.assertTrue((boolean)Arrays.equals(expectedData, loadedItem));
        }
    }

    private void assertStringHeader(byte[] header, int itemCount) {
        junit.framework.Assert.assertEquals((byte)PropertyType.STRING.byteValue(), (byte)header[0]);
        junit.framework.Assert.assertEquals((int)itemCount, (int)ByteBuffer.wrap(header, 1, 4).getInt());
    }

    private void assertBitPackedArrayGetsCorrectlySerializedAndDeserialized(Object array, PropertyType type, int expectedBitsUsedPerItem, int expectedRecordCount) {
        Collection<DynamicRecord> records = this.storeArray(array);
        Pair<byte[], byte[]> asBytes = this.loadArray(records);
        this.assertArrayHeader((byte[])asBytes.first(), type, expectedBitsUsedPerItem);
        Bits bits = Bits.bitsFromBytes((byte[])((byte[])asBytes.other()));
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            junit.framework.Assert.assertEquals((long)((Number)Array.get(array, i)).longValue(), (long)bits.getLong(expectedBitsUsedPerItem));
        }
    }

    private void assertArrayHeader(byte[] header, PropertyType type, int bitsPerItem) {
        junit.framework.Assert.assertEquals((byte)type.byteValue(), (byte)header[0]);
        junit.framework.Assert.assertEquals((int)bitsPerItem, (int)header[2]);
    }

    private Collection<DynamicRecord> storeArray(Object array) {
        Collection records = this.arrayStore.allocateRecords(this.arrayStore.nextBlockId(), array);
        for (DynamicRecord record : records) {
            this.arrayStore.updateRecord(record);
        }
        return records;
    }

    private Pair<byte[], byte[]> loadArray(Collection<DynamicRecord> records) {
        return PropertyStore.readFullByteArray((long)((DynamicRecord)IteratorUtil.first(records)).getId(), records, (AbstractDynamicStore)this.arrayStore, (PropertyType)PropertyType.ARRAY);
    }
}

